/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.actions;

import java.math.RoundingMode;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.actions.RewriteStrategy;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.FluentIterable;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.math.LongMath;
import org.apache.iceberg.util.BinPacking;
import org.apache.iceberg.util.PropertyUtil;

public abstract class BinPackStrategy
implements RewriteStrategy {
    public static final String MIN_INPUT_FILES = "min-input-files";
    public static final int MIN_INPUT_FILES_DEFAULT = 5;
    public static final String MIN_FILE_SIZE_BYTES = "min-file-size-bytes";
    public static final double MIN_FILE_SIZE_DEFAULT_RATIO = 0.75;
    public static final String MAX_FILE_SIZE_BYTES = "max-file-size-bytes";
    public static final double MAX_FILE_SIZE_DEFAULT_RATIO = 1.8;
    private int minInputFiles;
    private long minFileSize;
    private long maxFileSize;
    private long targetFileSize;
    private long maxGroupSize;

    @Override
    public String name() {
        return "BINPACK";
    }

    @Override
    public Set<String> validOptions() {
        return ImmutableSet.of(MIN_INPUT_FILES, MIN_FILE_SIZE_BYTES, MAX_FILE_SIZE_BYTES);
    }

    @Override
    public RewriteStrategy options(Map<String, String> options) {
        this.targetFileSize = PropertyUtil.propertyAsLong(options, "target-file-size-bytes", PropertyUtil.propertyAsLong(this.table().properties(), "write.target-file-size-bytes", 0x20000000L));
        this.minFileSize = PropertyUtil.propertyAsLong(options, MIN_FILE_SIZE_BYTES, (long)((double)this.targetFileSize * 0.75));
        this.maxFileSize = PropertyUtil.propertyAsLong(options, MAX_FILE_SIZE_BYTES, (long)((double)this.targetFileSize * 1.8));
        this.maxGroupSize = PropertyUtil.propertyAsLong(options, "max-file-group-size-bytes", 0x1900000000L);
        this.minInputFiles = PropertyUtil.propertyAsInt(options, MIN_INPUT_FILES, 5);
        this.validateOptions();
        return this;
    }

    @Override
    public Iterable<FileScanTask> selectFilesToRewrite(Iterable<FileScanTask> dataFiles) {
        return FluentIterable.from(dataFiles).filter(scanTask -> scanTask.length() < this.minFileSize || scanTask.length() > this.maxFileSize);
    }

    @Override
    public Iterable<List<FileScanTask>> planFileGroups(Iterable<FileScanTask> dataFiles) {
        BinPacking.ListPacker<FileScanTask> packer = new BinPacking.ListPacker<FileScanTask>(this.maxGroupSize, 1, false);
        List<List<FileScanTask>> potentialGroups = packer.pack(dataFiles, FileScanTask::length);
        return potentialGroups.stream().filter(group -> group.size() >= this.minInputFiles || this.sizeOfInputFiles((List<FileScanTask>)group) > this.targetFileSize).collect(Collectors.toList());
    }

    protected long targetFileSize() {
        return this.targetFileSize;
    }

    protected long numOutputFiles(long totalSizeInBytes) {
        if (totalSizeInBytes < this.targetFileSize) {
            return 1L;
        }
        long fileCountWithRemainder = LongMath.divide(totalSizeInBytes, this.targetFileSize, RoundingMode.CEILING);
        if (LongMath.mod(totalSizeInBytes, this.targetFileSize) > this.minFileSize) {
            return fileCountWithRemainder;
        }
        long fileCountWithoutRemainder = LongMath.divide(totalSizeInBytes, this.targetFileSize, RoundingMode.FLOOR);
        long avgFileSizeWithoutRemainder = totalSizeInBytes / fileCountWithoutRemainder;
        if ((double)avgFileSizeWithoutRemainder < Math.min(1.1 * (double)this.targetFileSize, (double)this.writeMaxFileSize())) {
            return fileCountWithoutRemainder;
        }
        return fileCountWithRemainder;
    }

    protected long splitSize(long totalSizeInBytes) {
        long estimatedSplitSize = totalSizeInBytes / this.numOutputFiles(totalSizeInBytes);
        return Math.min(estimatedSplitSize, this.writeMaxFileSize());
    }

    protected long inputFileSize(List<FileScanTask> fileToRewrite) {
        return fileToRewrite.stream().mapToLong(FileScanTask::length).sum();
    }

    protected long writeMaxFileSize() {
        return (long)((double)this.targetFileSize + (double)(this.maxFileSize - this.targetFileSize) * 0.5);
    }

    private long sizeOfInputFiles(List<FileScanTask> group) {
        return group.stream().mapToLong(FileScanTask::length).sum();
    }

    private void validateOptions() {
        Preconditions.checkArgument(this.minFileSize >= 0L, "Cannot set %s to a negative number, %d < 0", (Object)MIN_FILE_SIZE_BYTES, this.minFileSize);
        Preconditions.checkArgument(this.maxFileSize > this.minFileSize, "Cannot set %s greater than or equal to %s, %d >= %d", (Object)MIN_FILE_SIZE_BYTES, (Object)MAX_FILE_SIZE_BYTES, (Object)this.minFileSize, (Object)this.maxFileSize);
        Preconditions.checkArgument(this.targetFileSize > this.minFileSize, "Cannot set %s greater than or equal to %s, all files written will be smaller than the threshold, %d >= %d", (Object)MIN_FILE_SIZE_BYTES, (Object)"target-file-size-bytes", (Object)this.minFileSize, (Object)this.targetFileSize);
        Preconditions.checkArgument(this.targetFileSize < this.maxFileSize, "Cannot set %s is greater than or equal to %s, all files written will be larger than the threshold, %d >= %d", (Object)MAX_FILE_SIZE_BYTES, (Object)"target-file-size-bytes", (Object)this.maxFileSize, (Object)this.targetFileSize);
        Preconditions.checkArgument(this.minInputFiles > 0, "Cannot set %s is less than 1. All values less than 1 have the same effect as 1. %d < 1", (Object)MIN_INPUT_FILES, this.minInputFiles);
    }
}

