/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.actions;

import java.util.List;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.actions.SnapshotUpdate;
import org.apache.iceberg.expressions.Expression;

public interface RewriteDataFiles
extends SnapshotUpdate<RewriteDataFiles, Result> {
    public static final String PARTIAL_PROGRESS_ENABLED = "partial-progress.enabled";
    public static final boolean PARTIAL_PROGRESS_ENABLED_DEFAULT = false;
    public static final String PARTIAL_PROGRESS_MAX_COMMITS = "partial-progress.max-commits";
    public static final int PARTIAL_PROGRESS_MAX_COMMITS_DEFAULT = 10;
    public static final String MAX_FILE_GROUP_SIZE_BYTES = "max-file-group-size-bytes";
    public static final long MAX_FILE_GROUP_SIZE_BYTES_DEFAULT = 0x1900000000L;
    public static final String MAX_CONCURRENT_FILE_GROUP_REWRITES = "max-concurrent-file-group-rewrites";
    public static final int MAX_CONCURRENT_FILE_GROUP_REWRITES_DEFAULT = 1;
    public static final String TARGET_FILE_SIZE_BYTES = "target-file-size-bytes";

    default public RewriteDataFiles binPack() {
        return this;
    }

    public RewriteDataFiles filter(Expression var1);

    public static interface FileGroupInfo {
        public int globalIndex();

        public int partitionIndex();

        public StructLike partition();
    }

    public static interface FileGroupRewriteResult {
        public FileGroupInfo info();

        public int addedDataFilesCount();

        public int rewrittenDataFilesCount();
    }

    public static interface Result {
        public List<FileGroupRewriteResult> rewriteResults();

        default public int addedDataFilesCount() {
            return this.rewriteResults().stream().mapToInt(FileGroupRewriteResult::addedDataFilesCount).sum();
        }

        default public int rewrittenDataFilesCount() {
            return this.rewriteResults().stream().mapToInt(FileGroupRewriteResult::rewrittenDataFilesCount).sum();
        }
    }
}

