/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.actions;

import java.util.Map;
import java.util.Set;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.actions.BinPackStrategy;
import org.apache.iceberg.actions.RewriteStrategy;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.util.PropertyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SortStrategy
extends BinPackStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(SortStrategy.class);
    public static final String REWRITE_ALL = "rewrite-all";
    public static final boolean REWRITE_ALL_DEFAULT = false;
    private static final Set<String> validOptions = ImmutableSet.of("rewrite-all");
    private boolean rewriteAll;
    private SortOrder sortOrder;

    public SortStrategy sortOrder(SortOrder order) {
        this.sortOrder = order;
        return this;
    }

    protected SortOrder sortOrder() {
        return this.sortOrder;
    }

    @Override
    public String name() {
        return "SORT";
    }

    @Override
    public Set<String> validOptions() {
        return ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(super.validOptions())).addAll(validOptions)).build();
    }

    @Override
    public RewriteStrategy options(Map<String, String> options) {
        super.options(options);
        this.rewriteAll = PropertyUtil.propertyAsBoolean(options, REWRITE_ALL, false);
        if (this.sortOrder == null) {
            this.sortOrder = this.table().sortOrder();
        }
        this.validateOptions();
        return this;
    }

    @Override
    public Iterable<FileScanTask> selectFilesToRewrite(Iterable<FileScanTask> dataFiles) {
        if (this.rewriteAll) {
            LOG.info("Sort Strategy for table {} set to rewrite all data files", (Object)this.table().name());
            return dataFiles;
        }
        return super.selectFilesToRewrite(dataFiles);
    }

    protected void validateOptions() {
        Preconditions.checkArgument(!this.sortOrder.isUnsorted(), "Can't use %s when there is no sort order, either define table %s's sort order or set sortorder in the action", (Object)this.name(), (Object)this.table().name());
        SortOrder.checkCompatibility(this.sortOrder, this.table().schema());
    }
}

