/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aws.glue;

import java.util.Map;
import java.util.regex.Pattern;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.ValidationException;
import software.amazon.awssdk.services.glue.model.DatabaseInput;

class IcebergToGlueConverter {
    private static final Pattern GLUE_DB_PATTERN = Pattern.compile("^[a-z0-9_]{1,252}$");
    private static final Pattern GLUE_TABLE_PATTERN = Pattern.compile("^[a-z0-9_]{1,255}$");

    private IcebergToGlueConverter() {
    }

    static boolean isValidNamespace(Namespace namespace) {
        if (namespace.levels().length != 1) {
            return false;
        }
        String dbName = namespace.level(0);
        return dbName != null && GLUE_DB_PATTERN.matcher(dbName).find();
    }

    static void validateNamespace(Namespace namespace) {
        ValidationException.check(IcebergToGlueConverter.isValidNamespace(namespace), "Cannot convert namespace %s to Glue database name, because it must be 1-252 chars of lowercase letters, numbers, underscore", namespace);
    }

    static String toDatabaseName(Namespace namespace) {
        IcebergToGlueConverter.validateNamespace(namespace);
        return namespace.level(0);
    }

    static String getDatabaseName(TableIdentifier tableIdentifier) {
        return IcebergToGlueConverter.toDatabaseName(tableIdentifier.namespace());
    }

    static DatabaseInput toDatabaseInput(Namespace namespace, Map<String, String> metadata) {
        return (DatabaseInput)DatabaseInput.builder().name(IcebergToGlueConverter.toDatabaseName(namespace)).parameters(metadata).build();
    }

    static boolean isValidTableName(String tableName) {
        return tableName != null && GLUE_TABLE_PATTERN.matcher(tableName).find();
    }

    static void validateTableName(String tableName) {
        ValidationException.check(IcebergToGlueConverter.isValidTableName(tableName), "Cannot use %s as Glue table name, because it must be 1-255 chars of lowercase letters, numbers, underscore", tableName);
    }

    static String getTableName(TableIdentifier tableIdentifier) {
        IcebergToGlueConverter.validateTableName(tableIdentifier.name());
        return tableIdentifier.name();
    }

    static void validateTableIdentifier(TableIdentifier tableIdentifier) {
        IcebergToGlueConverter.validateNamespace(tableIdentifier.namespace());
        IcebergToGlueConverter.validateTableName(tableIdentifier.name());
    }
}

