/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aws.s3;

import java.util.Set;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;

class S3URI {
    private static final String SCHEME_DELIM = "://";
    private static final String PATH_DELIM = "/";
    private static final String QUERY_DELIM = "\\?";
    private static final String FRAGMENT_DELIM = "#";
    private static final Set<String> VALID_SCHEMES = ImmutableSet.of("https", "s3", "s3a", "s3n");
    private final String location;
    private final String bucket;
    private final String key;

    S3URI(String location) {
        Preconditions.checkNotNull(location, "Location cannot be null.");
        this.location = location;
        String[] schemeSplit = location.split(SCHEME_DELIM, -1);
        ValidationException.check(schemeSplit.length == 2, "Invalid S3 URI: %s", location);
        String scheme = schemeSplit[0];
        ValidationException.check(VALID_SCHEMES.contains(scheme.toLowerCase()), "Invalid scheme: %s", scheme);
        String[] authoritySplit = schemeSplit[1].split(PATH_DELIM, 2);
        ValidationException.check(authoritySplit.length == 2, "Invalid S3 URI: %s", location);
        ValidationException.check(!authoritySplit[1].trim().isEmpty(), "Invalid S3 key: %s", location);
        this.bucket = authoritySplit[0];
        String path = authoritySplit[1];
        path = path.split(QUERY_DELIM, -1)[0];
        this.key = path = path.split(FRAGMENT_DELIM, -1)[0];
    }

    public String bucket() {
        return this.bucket;
    }

    public String key() {
        return this.key;
    }

    public String location() {
        return this.location;
    }

    public String toString() {
        return this.location;
    }
}

