/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink;

import java.util.Set;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSinkFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.utils.TableSchemaUtils;
import org.apache.iceberg.flink.FlinkCatalog;
import org.apache.iceberg.flink.IcebergTableSink;
import org.apache.iceberg.flink.IcebergTableSource;
import org.apache.iceberg.flink.TableLoader;

public class FlinkDynamicTableFactory
implements DynamicTableSinkFactory,
DynamicTableSourceFactory {
    private final FlinkCatalog catalog;

    public FlinkDynamicTableFactory(FlinkCatalog catalog) {
        this.catalog = catalog;
    }

    public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
        ObjectPath objectPath = context.getObjectIdentifier().toObjectPath();
        TableLoader tableLoader = this.createTableLoader(objectPath);
        TableSchema tableSchema = TableSchemaUtils.getPhysicalSchema((TableSchema)context.getCatalogTable().getSchema());
        return new IcebergTableSource(tableLoader, tableSchema, context.getCatalogTable().getOptions(), context.getConfiguration());
    }

    public DynamicTableSink createDynamicTableSink(DynamicTableFactory.Context context) {
        ObjectPath objectPath = context.getObjectIdentifier().toObjectPath();
        TableLoader tableLoader = this.createTableLoader(objectPath);
        TableSchema tableSchema = TableSchemaUtils.getPhysicalSchema((TableSchema)context.getCatalogTable().getSchema());
        return new IcebergTableSink(tableLoader, tableSchema);
    }

    public Set<ConfigOption<?>> requiredOptions() {
        throw new UnsupportedOperationException("Iceberg Table Factory can not be loaded from Java SPI");
    }

    public Set<ConfigOption<?>> optionalOptions() {
        throw new UnsupportedOperationException("Iceberg Table Factory can not be loaded from Java SPI");
    }

    public String factoryIdentifier() {
        throw new UnsupportedOperationException("Iceberg Table Factory can not be loaded from Java SPI");
    }

    private TableLoader createTableLoader(ObjectPath objectPath) {
        return TableLoader.fromCatalog(this.catalog.getCatalogLoader(), this.catalog.toIdentifier(objectPath));
    }
}

