/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink;

import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.relocated.com.google.common.base.Strings;

class ManifestOutputFileFactory {
    static final String FLINK_MANIFEST_LOCATION = "flink.manifests.location";
    private final TableOperations ops;
    private final FileIO io;
    private final Map<String, String> props;
    private final String flinkJobId;
    private final int subTaskId;
    private final long attemptNumber;
    private final AtomicInteger fileCount = new AtomicInteger(0);

    ManifestOutputFileFactory(TableOperations ops, FileIO io, Map<String, String> props, String flinkJobId, int subTaskId, long attemptNumber) {
        this.ops = ops;
        this.io = io;
        this.props = props;
        this.flinkJobId = flinkJobId;
        this.subTaskId = subTaskId;
        this.attemptNumber = attemptNumber;
    }

    private String generatePath(long checkpointId) {
        return FileFormat.AVRO.addExtension(String.format("%s-%05d-%d-%d-%05d", this.flinkJobId, this.subTaskId, this.attemptNumber, checkpointId, this.fileCount.incrementAndGet()));
    }

    OutputFile create(long checkpointId) {
        String flinkManifestDir = this.props.get(FLINK_MANIFEST_LOCATION);
        String newManifestFullPath = Strings.isNullOrEmpty(flinkManifestDir) ? this.ops.metadataFileLocation(this.generatePath(checkpointId)) : String.format("%s/%s", ManifestOutputFileFactory.stripTrailingSlash(flinkManifestDir), this.generatePath(checkpointId));
        return this.io.newOutputFile(newManifestFullPath);
    }

    private static String stripTrailingSlash(String path) {
        String result = path;
        while (result.endsWith("/")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }
}

