/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source;

import java.util.Map;
import org.apache.flink.table.data.RowData;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.data.DeleteFilter;
import org.apache.iceberg.encryption.EncryptionManager;
import org.apache.iceberg.flink.FlinkSchemaUtil;
import org.apache.iceberg.flink.RowDataWrapper;
import org.apache.iceberg.flink.data.FlinkAvroReader;
import org.apache.iceberg.flink.data.FlinkOrcReader;
import org.apache.iceberg.flink.data.FlinkParquetReaders;
import org.apache.iceberg.flink.data.RowDataUtil;
import org.apache.iceberg.flink.source.DataIterator;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.mapping.NameMappingParser;
import org.apache.iceberg.orc.ORC;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.shaded.org.apache.orc.TypeDescription;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.util.PartitionUtil;

class RowDataIterator
extends DataIterator<RowData> {
    private final Schema tableSchema;
    private final Schema projectedSchema;
    private final String nameMapping;
    private final boolean caseSensitive;

    RowDataIterator(CombinedScanTask task, FileIO io, EncryptionManager encryption, Schema tableSchema, Schema projectedSchema, String nameMapping, boolean caseSensitive) {
        super(task, io, encryption);
        this.tableSchema = tableSchema;
        this.projectedSchema = projectedSchema;
        this.nameMapping = nameMapping;
        this.caseSensitive = caseSensitive;
    }

    @Override
    protected CloseableIterator<RowData> openTaskIterator(FileScanTask task) {
        Schema partitionSchema = TypeUtil.select(this.projectedSchema, task.spec().identitySourceIds());
        ImmutableMap idToConstant = partitionSchema.columns().isEmpty() ? ImmutableMap.of() : PartitionUtil.constantsMap(task, RowDataUtil::convertConstant);
        FlinkDeleteFilter deletes = new FlinkDeleteFilter(task, this.tableSchema, this.projectedSchema);
        CloseableIterable<RowData> iterable = deletes.filter(this.newIterable(task, deletes.requiredSchema(), idToConstant));
        return iterable.iterator();
    }

    private CloseableIterable<RowData> newIterable(FileScanTask task, Schema schema, Map<Integer, ?> idToConstant) {
        CloseableIterable<RowData> iter;
        if (task.isDataTask()) {
            throw new UnsupportedOperationException("Cannot read data task.");
        }
        switch (task.file().format()) {
            case PARQUET: {
                iter = this.newParquetIterable(task, schema, idToConstant);
                break;
            }
            case AVRO: {
                iter = this.newAvroIterable(task, schema, idToConstant);
                break;
            }
            case ORC: {
                iter = this.newOrcIterable(task, schema, idToConstant);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Cannot read unknown format: " + (Object)((Object)task.file().format()));
            }
        }
        return iter;
    }

    private CloseableIterable<RowData> newAvroIterable(FileScanTask task, Schema schema, Map<Integer, ?> idToConstant) {
        Avro.ReadBuilder builder = Avro.read(this.getInputFile(task)).reuseContainers().project(schema).split(task.start(), task.length()).createReaderFunc(readSchema -> new FlinkAvroReader(schema, (org.apache.iceberg.shaded.org.apache.avro.Schema)readSchema, idToConstant));
        if (this.nameMapping != null) {
            builder.withNameMapping(NameMappingParser.fromJson(this.nameMapping));
        }
        return builder.build();
    }

    private CloseableIterable<RowData> newParquetIterable(FileScanTask task, Schema schema, Map<Integer, ?> idToConstant) {
        Parquet.ReadBuilder builder = Parquet.read(this.getInputFile(task)).reuseContainers().split(task.start(), task.length()).project(schema).createReaderFunc(fileSchema -> FlinkParquetReaders.buildReader(schema, fileSchema, idToConstant)).filter(task.residual()).caseSensitive(this.caseSensitive).reuseContainers();
        if (this.nameMapping != null) {
            builder.withNameMapping(NameMappingParser.fromJson(this.nameMapping));
        }
        return builder.build();
    }

    private CloseableIterable<RowData> newOrcIterable(FileScanTask task, Schema schema, Map<Integer, ?> idToConstant) {
        Schema readSchemaWithoutConstantAndMetadataFields = TypeUtil.selectNot(schema, Sets.union(idToConstant.keySet(), MetadataColumns.metadataFieldIds()));
        ORC.ReadBuilder builder = ORC.read(this.getInputFile(task)).project(readSchemaWithoutConstantAndMetadataFields).split(task.start(), task.length()).createReaderFunc(readOrcSchema -> new FlinkOrcReader(schema, (TypeDescription)readOrcSchema, idToConstant)).filter(task.residual()).caseSensitive(this.caseSensitive);
        if (this.nameMapping != null) {
            builder.withNameMapping(NameMappingParser.fromJson(this.nameMapping));
        }
        return builder.build();
    }

    private class FlinkDeleteFilter
    extends DeleteFilter<RowData> {
        private final RowDataWrapper asStructLike;

        FlinkDeleteFilter(FileScanTask task, Schema tableSchema, Schema requestedSchema) {
            super(task, tableSchema, requestedSchema);
            this.asStructLike = new RowDataWrapper(FlinkSchemaUtil.convert(this.requiredSchema()), this.requiredSchema().asStruct());
        }

        @Override
        protected StructLike asStructLike(RowData row) {
            return this.asStructLike.wrap(row);
        }

        @Override
        protected InputFile getInputFile(String location) {
            return RowDataIterator.this.getInputFile(location);
        }
    }
}

