/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.shaded.io.airlift.compress.zstd;

import org.apache.iceberg.shaded.io.airlift.compress.zstd.BitOutputStream;
import org.apache.iceberg.shaded.io.airlift.compress.zstd.HuffmanCompressionTable;
import org.apache.iceberg.shaded.io.airlift.compress.zstd.UnsafeUtil;

class HuffmanCompressor {
    private HuffmanCompressor() {
    }

    public static int compress4streams(Object outputBase, long outputAddress, int outputSize, Object inputBase, long inputAddress, int inputSize, HuffmanCompressionTable table) {
        int compressedSize;
        long input = inputAddress;
        long inputLimit = inputAddress + (long)inputSize;
        long output = outputAddress;
        long outputLimit = outputAddress + (long)outputSize;
        int segmentSize = (inputSize + 3) / 4;
        if (outputSize < 17) {
            return 0;
        }
        if (inputSize <= 9) {
            return 0;
        }
        if ((compressedSize = HuffmanCompressor.compressSingleStream(outputBase, output += 6L, (int)(outputLimit - output), inputBase, input, segmentSize, table)) == 0) {
            return 0;
        }
        UnsafeUtil.UNSAFE.putShort(outputBase, outputAddress, (short)compressedSize);
        output += (long)compressedSize;
        compressedSize = HuffmanCompressor.compressSingleStream(outputBase, output, (int)(outputLimit - output), inputBase, input += (long)segmentSize, segmentSize, table);
        if (compressedSize == 0) {
            return 0;
        }
        UnsafeUtil.UNSAFE.putShort(outputBase, outputAddress + 2L, (short)compressedSize);
        output += (long)compressedSize;
        compressedSize = HuffmanCompressor.compressSingleStream(outputBase, output, (int)(outputLimit - output), inputBase, input += (long)segmentSize, segmentSize, table);
        if (compressedSize == 0) {
            return 0;
        }
        UnsafeUtil.UNSAFE.putShort(outputBase, outputAddress + 2L + 2L, (short)compressedSize);
        output += (long)compressedSize;
        compressedSize = HuffmanCompressor.compressSingleStream(outputBase, output, (int)(outputLimit - output), inputBase, input += (long)segmentSize, (int)(inputLimit - input), table);
        if (compressedSize == 0) {
            return 0;
        }
        return (int)((output += (long)compressedSize) - outputAddress);
    }

    public static int compressSingleStream(Object outputBase, long outputAddress, int outputSize, Object inputBase, long inputAddress, int inputSize, HuffmanCompressionTable table) {
        BitOutputStream bitstream = new BitOutputStream(outputBase, outputAddress, outputSize);
        long input = inputAddress;
        int n = inputSize & 0xFFFFFFFC;
        switch (inputSize & 3) {
            case 3: {
                table.encodeSymbol(bitstream, UnsafeUtil.UNSAFE.getByte(inputBase, input + (long)n + 2L) & 0xFF);
            }
            case 2: {
                table.encodeSymbol(bitstream, UnsafeUtil.UNSAFE.getByte(inputBase, input + (long)n + 1L) & 0xFF);
            }
            case 1: {
                table.encodeSymbol(bitstream, UnsafeUtil.UNSAFE.getByte(inputBase, input + (long)n + 0L) & 0xFF);
                bitstream.flush();
            }
        }
        while (n > 0) {
            table.encodeSymbol(bitstream, UnsafeUtil.UNSAFE.getByte(inputBase, input + (long)n - 1L) & 0xFF);
            table.encodeSymbol(bitstream, UnsafeUtil.UNSAFE.getByte(inputBase, input + (long)n - 2L) & 0xFF);
            table.encodeSymbol(bitstream, UnsafeUtil.UNSAFE.getByte(inputBase, input + (long)n - 3L) & 0xFF);
            table.encodeSymbol(bitstream, UnsafeUtil.UNSAFE.getByte(inputBase, input + (long)n - 4L) & 0xFF);
            bitstream.flush();
            n -= 4;
        }
        return bitstream.close();
    }
}

