/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.validation.constraints.Size;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.iceberg.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;
import org.projectnessie.model.Contents;
import org.projectnessie.model.HiveDatabase;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="HiveDatabase", generator="Immutables")
@Immutable
public final class ImmutableHiveDatabase
extends HiveDatabase {
    private final String id;
    @Size(min=1)
    private final @Size(min=1) byte[] databaseDefinition;
    private final transient int hashCode;

    private ImmutableHiveDatabase(Builder builder) {
        this.databaseDefinition = builder.databaseDefinition;
        this.id = builder.id != null ? builder.id : Objects.requireNonNull(super.getId(), "id");
        this.hashCode = this.computeHashCode();
    }

    private ImmutableHiveDatabase(String id, @Size(min=1) @Size(min=1) byte[] databaseDefinition) {
        this.id = id;
        this.databaseDefinition = databaseDefinition;
        this.hashCode = this.computeHashCode();
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="databaseDefinition")
    @Size(min=1)
    public @Size(min=1) byte[] getDatabaseDefinition() {
        return (byte[])this.databaseDefinition.clone();
    }

    public final ImmutableHiveDatabase withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableHiveDatabase(newValue, this.databaseDefinition);
    }

    public final ImmutableHiveDatabase withDatabaseDefinition(byte ... elements) {
        @Size(min=1) byte[] newValue = (byte[])elements.clone();
        return new ImmutableHiveDatabase(this.id, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableHiveDatabase && this.equalTo((ImmutableHiveDatabase)another);
    }

    private boolean equalTo(ImmutableHiveDatabase another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.id.equals(another.id) && Arrays.equals(this.databaseDefinition, another.databaseDefinition);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.id.hashCode();
        h2 += (h2 << 5) + Arrays.hashCode(this.databaseDefinition);
        return h2;
    }

    public String toString() {
        return "HiveDatabase{id=" + this.id + ", databaseDefinition=" + Arrays.toString(this.databaseDefinition) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableHiveDatabase fromJson(Json json) {
        Builder builder = ImmutableHiveDatabase.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.databaseDefinition != null) {
            builder.databaseDefinition(json.databaseDefinition);
        }
        return builder.build();
    }

    public static ImmutableHiveDatabase copyOf(HiveDatabase instance) {
        if (instance instanceof ImmutableHiveDatabase) {
            return (ImmutableHiveDatabase)instance;
        }
        return ImmutableHiveDatabase.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="HiveDatabase", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_DATABASE_DEFINITION = 1L;
        private long initBits = 1L;
        @Nullable
        private String id;
        @Nullable
        @Size(min=1)
        private @Size(min=1) byte[] databaseDefinition;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(HiveDatabase instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Contents instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Contents instance;
            if (object instanceof HiveDatabase) {
                instance = (HiveDatabase)object;
                this.databaseDefinition(((HiveDatabase)instance).getDatabaseDefinition());
            }
            if (object instanceof Contents) {
                instance = (Contents)object;
                this.id(instance.getId());
            }
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            return this;
        }

        @JsonProperty(value="databaseDefinition")
        @CanIgnoreReturnValue
        public final Builder databaseDefinition(byte ... databaseDefinition) {
            this.databaseDefinition = (byte[])databaseDefinition.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableHiveDatabase build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableHiveDatabase(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("databaseDefinition");
            }
            return "Cannot build HiveDatabase, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="HiveDatabase", generator="Immutables")
    static final class Json
    extends HiveDatabase {
        @Nullable
        String id;
        @Nullable
        @Size(min=1)
        @Size(min=1) byte[] databaseDefinition;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="databaseDefinition")
        public void setDatabaseDefinition(@Size(min=1) @Size(min=1) byte[] databaseDefinition) {
            this.databaseDefinition = databaseDefinition;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        @Size(min=1)
        public @Size(min=1) byte[] getDatabaseDefinition() {
            throw new UnsupportedOperationException();
        }
    }
}

