/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.iceberg.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.LogResponse;
import org.projectnessie.model.PaginatedResponse;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="LogResponse", generator="Immutables")
@Immutable
public final class ImmutableLogResponse
implements LogResponse {
    private final boolean hasMore;
    @Nullable
    private final String token;
    private final List<CommitMeta> operations;
    private final transient int hashCode;

    private ImmutableLogResponse(Builder builder) {
        this.token = builder.token;
        this.operations = ImmutableLogResponse.createUnmodifiableList(true, builder.operations);
        this.hasMore = builder.hasMoreIsSet() ? builder.hasMore : LogResponse.super.hasMore();
        this.hashCode = this.computeHashCode();
    }

    private ImmutableLogResponse(boolean hasMore, @Nullable String token, List<CommitMeta> operations) {
        this.hasMore = hasMore;
        this.token = token;
        this.operations = operations;
        this.hashCode = this.computeHashCode();
    }

    @Override
    @JsonProperty(value="hasMore")
    public boolean hasMore() {
        return this.hasMore;
    }

    @Override
    @JsonProperty(value="token")
    @Nullable
    public String getToken() {
        return this.token;
    }

    @Override
    @JsonProperty(value="operations")
    public List<CommitMeta> getOperations() {
        return this.operations;
    }

    public final ImmutableLogResponse withHasMore(boolean value) {
        if (this.hasMore == value) {
            return this;
        }
        return new ImmutableLogResponse(value, this.token, this.operations);
    }

    public final ImmutableLogResponse withToken(@Nullable String value) {
        if (Objects.equals(this.token, value)) {
            return this;
        }
        return new ImmutableLogResponse(this.hasMore, value, this.operations);
    }

    public final ImmutableLogResponse withOperations(CommitMeta ... elements) {
        List<CommitMeta> newValue = ImmutableLogResponse.createUnmodifiableList(false, ImmutableLogResponse.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableLogResponse(this.hasMore, this.token, newValue);
    }

    public final ImmutableLogResponse withOperations(Iterable<? extends CommitMeta> elements) {
        if (this.operations == elements) {
            return this;
        }
        List<CommitMeta> newValue = ImmutableLogResponse.createUnmodifiableList(false, ImmutableLogResponse.createSafeList(elements, true, false));
        return new ImmutableLogResponse(this.hasMore, this.token, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLogResponse && this.equalTo((ImmutableLogResponse)another);
    }

    private boolean equalTo(ImmutableLogResponse another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.hasMore == another.hasMore && Objects.equals(this.token, another.token) && this.operations.equals(another.operations);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Boolean.hashCode(this.hasMore);
        h2 += (h2 << 5) + Objects.hashCode(this.token);
        h2 += (h2 << 5) + this.operations.hashCode();
        return h2;
    }

    public String toString() {
        return "LogResponse{hasMore=" + this.hasMore + ", token=" + this.token + ", operations=" + this.operations + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableLogResponse fromJson(Json json) {
        Builder builder = ImmutableLogResponse.builder();
        if (json.hasMoreIsSet) {
            builder.hasMore(json.hasMore);
        }
        if (json.token != null) {
            builder.token(json.token);
        }
        if (json.operations != null) {
            builder.addAllOperations(json.operations);
        }
        return builder.build();
    }

    public static ImmutableLogResponse copyOf(LogResponse instance) {
        if (instance instanceof ImmutableLogResponse) {
            return (ImmutableLogResponse)instance;
        }
        return ImmutableLogResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="LogResponse", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_HAS_MORE = 1L;
        private long optBits;
        private boolean hasMore;
        @Nullable
        private String token;
        private List<CommitMeta> operations = new ArrayList<CommitMeta>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(LogResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(PaginatedResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PaginatedResponse instance;
            if (object instanceof LogResponse) {
                instance = (LogResponse)object;
                this.addAllOperations(instance.getOperations());
            }
            if (object instanceof PaginatedResponse) {
                instance = (PaginatedResponse)object;
                this.hasMore(instance.hasMore());
                String tokenValue = instance.getToken();
                if (tokenValue != null) {
                    this.token(tokenValue);
                }
            }
        }

        @JsonProperty(value="hasMore")
        @CanIgnoreReturnValue
        public final Builder hasMore(boolean hasMore) {
            this.hasMore = hasMore;
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="token")
        @CanIgnoreReturnValue
        public final Builder token(@Nullable String token) {
            this.token = token;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addOperations(CommitMeta element) {
            this.operations.add(Objects.requireNonNull(element, "operations element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addOperations(CommitMeta ... elements) {
            for (CommitMeta element : elements) {
                this.operations.add(Objects.requireNonNull(element, "operations element"));
            }
            return this;
        }

        @JsonProperty(value="operations")
        @CanIgnoreReturnValue
        public final Builder operations(Iterable<? extends CommitMeta> elements) {
            this.operations.clear();
            return this.addAllOperations(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllOperations(Iterable<? extends CommitMeta> elements) {
            for (CommitMeta commitMeta : elements) {
                this.operations.add(Objects.requireNonNull(commitMeta, "operations element"));
            }
            return this;
        }

        public ImmutableLogResponse build() {
            return new ImmutableLogResponse(this);
        }

        private boolean hasMoreIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="LogResponse", generator="Immutables")
    static final class Json
    implements LogResponse {
        boolean hasMore;
        boolean hasMoreIsSet;
        @Nullable
        String token;
        @Nullable
        List<CommitMeta> operations = Collections.emptyList();

        Json() {
        }

        @JsonProperty(value="hasMore")
        public void setHasMore(boolean hasMore) {
            this.hasMore = hasMore;
            this.hasMoreIsSet = true;
        }

        @JsonProperty(value="token")
        public void setToken(@Nullable String token) {
            this.token = token;
        }

        @JsonProperty(value="operations")
        public void setOperations(List<CommitMeta> operations) {
            this.operations = operations;
        }

        @Override
        public boolean hasMore() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getToken() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<CommitMeta> getOperations() {
            throw new UnsupportedOperationException();
        }
    }
}

