/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.json.gson;

import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonParser;
import com.google.api.client.json.JsonToken;
import com.google.api.client.json.gson.GsonFactory;
import java.io.EOFException;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.apache.iceberg.gcp.shaded.com.google.gson.stream.JsonReader;

class GsonParser
extends JsonParser {
    private final JsonReader reader;
    private final GsonFactory factory;
    private List<String> currentNameStack = new ArrayList<String>();
    private JsonToken currentToken;
    private String currentText;

    GsonParser(GsonFactory factory, JsonReader reader) {
        this.factory = factory;
        this.reader = reader;
        reader.setLenient(factory.getReadLeniency());
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public String getCurrentName() {
        return this.currentNameStack.isEmpty() ? null : this.currentNameStack.get(this.currentNameStack.size() - 1);
    }

    @Override
    public JsonToken getCurrentToken() {
        return this.currentToken;
    }

    @Override
    public JsonFactory getFactory() {
        return this.factory;
    }

    @Override
    public byte getByteValue() throws IOException {
        this.checkNumber();
        return Byte.parseByte(this.currentText);
    }

    @Override
    public short getShortValue() throws IOException {
        this.checkNumber();
        return Short.parseShort(this.currentText);
    }

    @Override
    public int getIntValue() throws IOException {
        this.checkNumber();
        return Integer.parseInt(this.currentText);
    }

    @Override
    public float getFloatValue() throws IOException {
        this.checkNumber();
        return Float.parseFloat(this.currentText);
    }

    @Override
    public BigInteger getBigIntegerValue() throws IOException {
        this.checkNumber();
        return new BigInteger(this.currentText);
    }

    @Override
    public BigDecimal getDecimalValue() throws IOException {
        this.checkNumber();
        return new BigDecimal(this.currentText);
    }

    @Override
    public double getDoubleValue() throws IOException {
        this.checkNumber();
        return Double.parseDouble(this.currentText);
    }

    @Override
    public long getLongValue() throws IOException {
        this.checkNumber();
        return Long.parseLong(this.currentText);
    }

    private void checkNumber() throws IOException {
        if (this.currentToken != JsonToken.VALUE_NUMBER_INT && this.currentToken != JsonToken.VALUE_NUMBER_FLOAT) {
            throw new IOException("Token is not a number");
        }
    }

    @Override
    public String getText() {
        return this.currentText;
    }

    @Override
    public JsonToken nextToken() throws IOException {
        org.apache.iceberg.gcp.shaded.com.google.gson.stream.JsonToken peek;
        if (this.currentToken != null) {
            switch (this.currentToken) {
                case START_ARRAY: {
                    this.reader.beginArray();
                    this.currentNameStack.add(null);
                    break;
                }
                case START_OBJECT: {
                    this.reader.beginObject();
                    this.currentNameStack.add(null);
                    break;
                }
            }
        }
        try {
            peek = this.reader.peek();
        }
        catch (EOFException e) {
            peek = org.apache.iceberg.gcp.shaded.com.google.gson.stream.JsonToken.END_DOCUMENT;
        }
        switch (peek) {
            case BEGIN_ARRAY: {
                this.currentText = "[";
                this.currentToken = JsonToken.START_ARRAY;
                break;
            }
            case END_ARRAY: {
                this.currentText = "]";
                this.currentToken = JsonToken.END_ARRAY;
                this.currentNameStack.remove(this.currentNameStack.size() - 1);
                this.reader.endArray();
                break;
            }
            case BEGIN_OBJECT: {
                this.currentText = "{";
                this.currentToken = JsonToken.START_OBJECT;
                break;
            }
            case END_OBJECT: {
                this.currentText = "}";
                this.currentToken = JsonToken.END_OBJECT;
                this.currentNameStack.remove(this.currentNameStack.size() - 1);
                this.reader.endObject();
                break;
            }
            case BOOLEAN: {
                if (this.reader.nextBoolean()) {
                    this.currentText = "true";
                    this.currentToken = JsonToken.VALUE_TRUE;
                    break;
                }
                this.currentText = "false";
                this.currentToken = JsonToken.VALUE_FALSE;
                break;
            }
            case NULL: {
                this.currentText = "null";
                this.currentToken = JsonToken.VALUE_NULL;
                this.reader.nextNull();
                break;
            }
            case STRING: {
                this.currentText = this.reader.nextString();
                this.currentToken = JsonToken.VALUE_STRING;
                break;
            }
            case NUMBER: {
                this.currentText = this.reader.nextString();
                this.currentToken = this.currentText.indexOf(46) == -1 ? JsonToken.VALUE_NUMBER_INT : JsonToken.VALUE_NUMBER_FLOAT;
                break;
            }
            case NAME: {
                this.currentText = this.reader.nextName();
                this.currentToken = JsonToken.FIELD_NAME;
                this.currentNameStack.set(this.currentNameStack.size() - 1, this.currentText);
                break;
            }
            default: {
                this.currentText = null;
                this.currentToken = null;
            }
        }
        return this.currentToken;
    }

    @Override
    public JsonParser skipChildren() throws IOException {
        if (this.currentToken != null) {
            switch (this.currentToken) {
                case START_ARRAY: {
                    this.reader.skipValue();
                    this.currentText = "]";
                    this.currentToken = JsonToken.END_ARRAY;
                    break;
                }
                case START_OBJECT: {
                    this.reader.skipValue();
                    this.currentText = "}";
                    this.currentToken = JsonToken.END_OBJECT;
                    break;
                }
            }
        }
        return this;
    }
}

