/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.tracing;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.tracing.MetricsRecorder;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.Meter;
import java.util.Map;
import org.apache.iceberg.gcp.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.gcp.shaded.com.google.common.base.Preconditions;

@BetaApi
@InternalApi
public class OpenTelemetryMetricsRecorder
implements MetricsRecorder {
    public static final String GAX_METER_NAME = "gax-java";
    private final DoubleHistogram attemptLatencyRecorder;
    private final DoubleHistogram operationLatencyRecorder;
    private final LongCounter operationCountRecorder;
    private final LongCounter attemptCountRecorder;

    public OpenTelemetryMetricsRecorder(OpenTelemetry openTelemetry, String serviceName) {
        Meter meter = openTelemetry.meterBuilder(GAX_METER_NAME).setInstrumentationVersion(GaxProperties.getGaxVersion()).build();
        this.attemptLatencyRecorder = meter.histogramBuilder(serviceName + "/attempt_latency").setDescription("Time an individual attempt took").setUnit("ms").build();
        this.operationLatencyRecorder = meter.histogramBuilder(serviceName + "/operation_latency").setDescription("Total time until final operation success or failure, including retries and backoff.").setUnit("ms").build();
        this.attemptCountRecorder = meter.counterBuilder(serviceName + "/attempt_count").setDescription("Number of Attempts").setUnit("1").build();
        this.operationCountRecorder = meter.counterBuilder(serviceName + "/operation_count").setDescription("Number of Operations").setUnit("1").build();
    }

    @Override
    public void recordAttemptLatency(double attemptLatency, Map<String, String> attributes) {
        this.attemptLatencyRecorder.record(attemptLatency, this.toOtelAttributes(attributes));
    }

    @Override
    public void recordAttemptCount(long count, Map<String, String> attributes) {
        this.attemptCountRecorder.add(count, this.toOtelAttributes(attributes));
    }

    @Override
    public void recordOperationLatency(double operationLatency, Map<String, String> attributes) {
        this.operationLatencyRecorder.record(operationLatency, this.toOtelAttributes(attributes));
    }

    @Override
    public void recordOperationCount(long count, Map<String, String> attributes) {
        this.operationCountRecorder.add(count, this.toOtelAttributes(attributes));
    }

    @VisibleForTesting
    Attributes toOtelAttributes(Map<String, String> attributes) {
        Preconditions.checkNotNull(attributes, "Attributes map cannot be null");
        AttributesBuilder attributesBuilder = Attributes.builder();
        attributes.forEach(attributesBuilder::put);
        return attributesBuilder.build();
    }
}

