/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud;

import com.google.api.core.BetaApi;
import com.google.auto.value.AutoValue;
import com.google.cloud.AutoValue_Binding;
import com.google.cloud.Condition;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;
import org.apache.iceberg.gcp.shaded.com.google.common.base.Predicate;
import org.apache.iceberg.gcp.shaded.com.google.common.base.Predicates;
import org.apache.iceberg.gcp.shaded.com.google.common.collect.Collections2;
import org.apache.iceberg.gcp.shaded.com.google.common.collect.ImmutableList;
import org.apache.iceberg.gcp.shaded.com.google.common.collect.Lists;

@BetaApi(value="This is a Beta API is not stable yet and may change in the future.")
@AutoValue
public abstract class Binding {
    public abstract String getRole();

    public abstract ImmutableList<String> getMembers();

    @Nullable
    public abstract Condition getCondition();

    public abstract Builder toBuilder();

    public static Builder newBuilder() {
        ImmutableList<String> emptyMembers = ImmutableList.of();
        return new AutoValue_Binding.Builder().setMembers(emptyMembers);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setRole(String var1);

        public abstract Builder setMembers(Iterable<String> var1);

        public abstract Builder setCondition(Condition var1);

        abstract ImmutableList<String> getMembers();

        public Builder addMembers(String member, String ... moreMembers) {
            ImmutableList.Builder membersBuilder = ImmutableList.builder();
            membersBuilder.addAll(this.getMembers());
            membersBuilder.addAll(Lists.asList(member, moreMembers));
            this.setMembers(membersBuilder.build());
            return this;
        }

        public Builder removeMembers(String ... members) {
            Predicate<String> selectMembersNotInList = Predicates.not(Predicates.in(Arrays.asList(members)));
            Collection<String> filter = Collections2.filter(this.getMembers(), selectMembersNotInList);
            this.setMembers(filter);
            return this;
        }

        public abstract Binding build();
    }
}

