/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.RecoveryFile;
import com.google.cloud.storage.ThroughputSink;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.iceberg.gcp.shaded.com.google.common.base.Preconditions;
import org.apache.iceberg.gcp.shaded.com.google.common.collect.ImmutableList;
import org.apache.iceberg.gcp.shaded.com.google.common.hash.HashCode;
import org.apache.iceberg.gcp.shaded.com.google.common.hash.HashFunction;
import org.apache.iceberg.gcp.shaded.com.google.common.hash.Hasher;
import org.apache.iceberg.gcp.shaded.com.google.common.hash.Hashing;

final class RecoveryFileManager {
    private final ImmutableList<RecoveryVolume> volumes;
    private final Map<BlobInfo, RecoveryFile> files;
    private final HashFunction hashFunction;
    private int nextVolumeIndex;

    private RecoveryFileManager(List<RecoveryVolume> volumes) {
        this.volumes = ImmutableList.copyOf(volumes);
        this.files = Collections.synchronizedMap(new HashMap());
        this.nextVolumeIndex = 0;
        this.hashFunction = Hashing.goodFastHash(64);
    }

    public RecoveryFile newRecoveryFile(BlobInfo info) {
        int i = this.getNextVolumeIndex();
        RecoveryVolume v = (RecoveryVolume)this.volumes.get(i);
        UUID uuid = UUID.randomUUID();
        String string = uuid.toString();
        Hasher hasher = this.hashFunction.newHasher();
        HashCode hash = hasher.putString(string, StandardCharsets.UTF_8).hash();
        String fileName = Base64.getUrlEncoder().encodeToString(hash.asBytes());
        Path path = v.basePath.resolve(fileName);
        RecoveryFile recoveryFile = new RecoveryFile(path, v.sink, () -> this.files.remove(info));
        this.files.put(info, recoveryFile);
        return recoveryFile;
    }

    private synchronized int getNextVolumeIndex() {
        this.nextVolumeIndex = (this.nextVolumeIndex + 1) % this.volumes.size();
        return this.nextVolumeIndex;
    }

    static RecoveryFileManager of(List<Path> volumes) throws IOException {
        return RecoveryFileManager.of(volumes, p -> ThroughputSink.nullSink());
    }

    static RecoveryFileManager of(List<Path> volumes, RecoveryVolumeSinkFactory factory) throws IOException {
        Preconditions.checkArgument(!volumes.isEmpty(), "At least one volume must be specified");
        Preconditions.checkArgument(volumes.stream().allMatch(p -> !Files.exists(p, new LinkOption[0]) || Files.isDirectory(p, new LinkOption[0])), "All provided volumes must either:\n1. Not yet exists\n2. Be directories");
        for (Path v : volumes) {
            if (Files.exists(v, new LinkOption[0])) continue;
            Files.createDirectories(v, new FileAttribute[0]);
        }
        ImmutableList<RecoveryVolume> recoveryVolumes = volumes.stream().map(p -> RecoveryVolume.of(p, factory.apply((Path)p))).collect(ImmutableList.toImmutableList());
        return new RecoveryFileManager(recoveryVolumes);
    }

    static final class RecoveryVolume {
        private final Path basePath;
        private final ThroughputSink sink;

        private RecoveryVolume(Path basePath, ThroughputSink sink) {
            this.basePath = basePath;
            this.sink = sink;
        }

        public static RecoveryVolume of(Path basePath, ThroughputSink sink) {
            return new RecoveryVolume(basePath, sink);
        }
    }

    @FunctionalInterface
    static interface RecoveryVolumeSinkFactory {
        public ThroughputSink apply(Path var1);
    }
}

