/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.v3;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iceberg.gcp.shaded.com.google.common.base.Preconditions;
import org.apache.iceberg.gcp.shaded.com.google.common.collect.ImmutableMap;

public class AlertPolicyName
implements ResourceName {
    private static final PathTemplate PROJECT_ALERT_POLICY = PathTemplate.createWithoutUrlEncoding("projects/{project}/alertPolicies/{alert_policy}");
    private static final PathTemplate ORGANIZATION_ALERT_POLICY = PathTemplate.createWithoutUrlEncoding("organizations/{organization}/alertPolicies/{alert_policy}");
    private static final PathTemplate FOLDER_ALERT_POLICY = PathTemplate.createWithoutUrlEncoding("folders/{folder}/alertPolicies/{alert_policy}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String alertPolicy;
    private final String organization;
    private final String folder;

    @Deprecated
    protected AlertPolicyName() {
        this.project = null;
        this.alertPolicy = null;
        this.organization = null;
        this.folder = null;
    }

    private AlertPolicyName(Builder builder) {
        this.project = Preconditions.checkNotNull(builder.getProject());
        this.alertPolicy = Preconditions.checkNotNull(builder.getAlertPolicy());
        this.organization = null;
        this.folder = null;
        this.pathTemplate = PROJECT_ALERT_POLICY;
    }

    private AlertPolicyName(OrganizationAlertPolicyBuilder builder) {
        this.organization = Preconditions.checkNotNull(builder.getOrganization());
        this.alertPolicy = Preconditions.checkNotNull(builder.getAlertPolicy());
        this.project = null;
        this.folder = null;
        this.pathTemplate = ORGANIZATION_ALERT_POLICY;
    }

    private AlertPolicyName(FolderAlertPolicyBuilder builder) {
        this.folder = Preconditions.checkNotNull(builder.getFolder());
        this.alertPolicy = Preconditions.checkNotNull(builder.getAlertPolicy());
        this.project = null;
        this.organization = null;
        this.pathTemplate = FOLDER_ALERT_POLICY;
    }

    public String getProject() {
        return this.project;
    }

    public String getAlertPolicy() {
        return this.alertPolicy;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getFolder() {
        return this.folder;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newProjectAlertPolicyBuilder() {
        return new Builder();
    }

    public static OrganizationAlertPolicyBuilder newOrganizationAlertPolicyBuilder() {
        return new OrganizationAlertPolicyBuilder();
    }

    public static FolderAlertPolicyBuilder newFolderAlertPolicyBuilder() {
        return new FolderAlertPolicyBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AlertPolicyName of(String project, String alertPolicy) {
        return AlertPolicyName.newBuilder().setProject(project).setAlertPolicy(alertPolicy).build();
    }

    public static AlertPolicyName ofProjectAlertPolicyName(String project, String alertPolicy) {
        return AlertPolicyName.newBuilder().setProject(project).setAlertPolicy(alertPolicy).build();
    }

    public static AlertPolicyName ofOrganizationAlertPolicyName(String organization, String alertPolicy) {
        return AlertPolicyName.newOrganizationAlertPolicyBuilder().setOrganization(organization).setAlertPolicy(alertPolicy).build();
    }

    public static AlertPolicyName ofFolderAlertPolicyName(String folder, String alertPolicy) {
        return AlertPolicyName.newFolderAlertPolicyBuilder().setFolder(folder).setAlertPolicy(alertPolicy).build();
    }

    public static String format(String project, String alertPolicy) {
        return AlertPolicyName.newBuilder().setProject(project).setAlertPolicy(alertPolicy).build().toString();
    }

    public static String formatProjectAlertPolicyName(String project, String alertPolicy) {
        return AlertPolicyName.newBuilder().setProject(project).setAlertPolicy(alertPolicy).build().toString();
    }

    public static String formatOrganizationAlertPolicyName(String organization, String alertPolicy) {
        return AlertPolicyName.newOrganizationAlertPolicyBuilder().setOrganization(organization).setAlertPolicy(alertPolicy).build().toString();
    }

    public static String formatFolderAlertPolicyName(String folder, String alertPolicy) {
        return AlertPolicyName.newFolderAlertPolicyBuilder().setFolder(folder).setAlertPolicy(alertPolicy).build().toString();
    }

    public static AlertPolicyName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_ALERT_POLICY.matches(formattedString)) {
            Map<String, String> matchMap = PROJECT_ALERT_POLICY.match(formattedString);
            return AlertPolicyName.ofProjectAlertPolicyName(matchMap.get("project"), matchMap.get("alert_policy"));
        }
        if (ORGANIZATION_ALERT_POLICY.matches(formattedString)) {
            Map<String, String> matchMap = ORGANIZATION_ALERT_POLICY.match(formattedString);
            return AlertPolicyName.ofOrganizationAlertPolicyName(matchMap.get("organization"), matchMap.get("alert_policy"));
        }
        if (FOLDER_ALERT_POLICY.matches(formattedString)) {
            Map<String, String> matchMap = FOLDER_ALERT_POLICY.match(formattedString);
            return AlertPolicyName.ofFolderAlertPolicyName(matchMap.get("folder"), matchMap.get("alert_policy"));
        }
        throw new ValidationException("AlertPolicyName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<AlertPolicyName> parseList(List<String> formattedStrings) {
        ArrayList<AlertPolicyName> list = new ArrayList<AlertPolicyName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AlertPolicyName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AlertPolicyName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AlertPolicyName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_ALERT_POLICY.matches(formattedString) || ORGANIZATION_ALERT_POLICY.matches(formattedString) || FOLDER_ALERT_POLICY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AlertPolicyName alertPolicyName = this;
            synchronized (alertPolicyName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder<String, String> fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put("project", this.project);
                    }
                    if (this.alertPolicy != null) {
                        fieldMapBuilder.put("alert_policy", this.alertPolicy);
                    }
                    if (this.organization != null) {
                        fieldMapBuilder.put("organization", this.organization);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put("folder", this.folder);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    @Override
    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AlertPolicyName that = (AlertPolicyName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.alertPolicy, that.alertPolicy) && Objects.equals(this.organization, that.organization) && Objects.equals(this.folder, that.folder);
        }
        return false;
    }

    public int hashCode() {
        int h2 = 1;
        h2 *= 1000003;
        h2 ^= Objects.hashCode(this.fixedValue);
        h2 *= 1000003;
        h2 ^= Objects.hashCode(this.project);
        h2 *= 1000003;
        h2 ^= Objects.hashCode(this.alertPolicy);
        h2 *= 1000003;
        h2 ^= Objects.hashCode(this.organization);
        h2 *= 1000003;
        return h2 ^= Objects.hashCode(this.folder);
    }

    public static class FolderAlertPolicyBuilder {
        private String folder;
        private String alertPolicy;

        protected FolderAlertPolicyBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public String getAlertPolicy() {
            return this.alertPolicy;
        }

        public FolderAlertPolicyBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public FolderAlertPolicyBuilder setAlertPolicy(String alertPolicy) {
            this.alertPolicy = alertPolicy;
            return this;
        }

        public AlertPolicyName build() {
            return new AlertPolicyName(this);
        }
    }

    public static class OrganizationAlertPolicyBuilder {
        private String organization;
        private String alertPolicy;

        protected OrganizationAlertPolicyBuilder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getAlertPolicy() {
            return this.alertPolicy;
        }

        public OrganizationAlertPolicyBuilder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public OrganizationAlertPolicyBuilder setAlertPolicy(String alertPolicy) {
            this.alertPolicy = alertPolicy;
            return this;
        }

        public AlertPolicyName build() {
            return new AlertPolicyName(this);
        }
    }

    public static class Builder {
        private String project;
        private String alertPolicy;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getAlertPolicy() {
            return this.alertPolicy;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setAlertPolicy(String alertPolicy) {
            this.alertPolicy = alertPolicy;
            return this;
        }

        private Builder(AlertPolicyName alertPolicyName) {
            Preconditions.checkArgument(Objects.equals(alertPolicyName.pathTemplate, PROJECT_ALERT_POLICY), "toBuilder is only supported when AlertPolicyName has the pattern of projects/{project}/alertPolicies/{alert_policy}");
            this.project = alertPolicyName.project;
            this.alertPolicy = alertPolicyName.alertPolicy;
        }

        public AlertPolicyName build() {
            return new AlertPolicyName(this);
        }
    }
}

