/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.rls;

import io.grpc.internal.JsonUtil;
import io.grpc.lookup.v1.RouteLookupRequest;
import io.grpc.lookup.v1.RouteLookupResponse;
import io.grpc.rls.RlsProtoData;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.iceberg.gcp.shaded.com.google.common.base.Converter;
import org.apache.iceberg.gcp.shaded.com.google.common.base.Preconditions;
import org.apache.iceberg.gcp.shaded.com.google.common.base.Strings;
import org.apache.iceberg.gcp.shaded.com.google.common.collect.ImmutableCollection;
import org.apache.iceberg.gcp.shaded.com.google.common.collect.ImmutableList;
import org.apache.iceberg.gcp.shaded.com.google.common.collect.ImmutableMap;

final class RlsProtoConverters {
    private static final long MAX_AGE_NANOS = TimeUnit.MINUTES.toNanos(5L);
    private static final long MAX_CACHE_SIZE = 0x500000L;
    private static final long DEFAULT_LOOKUP_SERVICE_TIMEOUT = TimeUnit.SECONDS.toNanos(10L);
    private static final ImmutableList<String> EXTRA_KEY_NAMES = ImmutableList.of("host", "service", "method");

    private static void checkKeys(Set<String> keys, String key, String keyType) {
        Preconditions.checkArgument(key != null, "unset " + keyType + "  key");
        Preconditions.checkArgument(!key.isEmpty(), "Empty string for " + keyType + " key");
        Preconditions.checkArgument(keys.add(key), "duplicate " + keyType + " key in grpc_keybuilders: " + key);
    }

    private static void checkUniqueKey(List<RlsProtoData.NameMatcher> nameMatchers, Set<String> constantKeys) {
        HashSet<String> keys = new HashSet<String>(constantKeys);
        keys.addAll(EXTRA_KEY_NAMES);
        for (RlsProtoData.NameMatcher nameMatcher : nameMatchers) {
            keys.add(nameMatcher.key());
        }
        if (keys.size() != nameMatchers.size() + constantKeys.size() + EXTRA_KEY_NAMES.size()) {
            throw new IllegalArgumentException("keys in KeyBuilder must be unique");
        }
    }

    private RlsProtoConverters() {
    }

    private static final class GrpcKeyBuilderConverter {
        private GrpcKeyBuilderConverter() {
        }

        public static ImmutableList<RlsProtoData.GrpcKeyBuilder> covertAll(List<Map<String, ?>> keyBuilders) {
            ImmutableList.Builder keyBuilderList = ImmutableList.builder();
            for (Map<String, ?> keyBuilder : keyBuilders) {
                keyBuilderList.add(GrpcKeyBuilderConverter.convert(keyBuilder));
            }
            return keyBuilderList.build();
        }

        static RlsProtoData.GrpcKeyBuilder convert(Map<String, ?> keyBuilder) {
            Map<String, ?> constantKeys;
            List<?> rawRawNames = JsonUtil.getList(keyBuilder, "names");
            Preconditions.checkArgument(rawRawNames != null && !rawRawNames.isEmpty(), "each keyBuilder must have at least one name");
            List<Map<String, ?>> rawNames = JsonUtil.checkObjectList(rawRawNames);
            ImmutableList.Builder namesBuilder = ImmutableList.builder();
            for (Map<String, ?> rawName : rawNames) {
                String serviceName = JsonUtil.getString(rawName, "service");
                Preconditions.checkArgument(!Strings.isNullOrEmpty(serviceName), "service must not be empty or null");
                namesBuilder.add(RlsProtoData.GrpcKeyBuilder.Name.create(serviceName, JsonUtil.getString(rawName, "method")));
            }
            List<?> rawRawHeaders = JsonUtil.getList(keyBuilder, "headers");
            List<Object> rawHeaders = rawRawHeaders == null ? new ArrayList() : JsonUtil.checkObjectList(rawRawHeaders);
            ImmutableList.Builder nameMatchersBuilder = ImmutableList.builder();
            for (Map map : rawHeaders) {
                Boolean requiredMatch = JsonUtil.getBoolean(map, "requiredMatch");
                Preconditions.checkArgument(requiredMatch == null || requiredMatch == false, "requiredMatch shouldn't be specified for gRPC");
                RlsProtoData.NameMatcher matcher = RlsProtoData.NameMatcher.create(JsonUtil.getString(map, "key"), ImmutableList.copyOf((List)map.get("names")));
                nameMatchersBuilder.add(matcher);
            }
            RlsProtoData.ExtraKeys extraKeys = RlsProtoData.ExtraKeys.DEFAULT;
            Map<String, ?> map = JsonUtil.getObject(keyBuilder, "extraKeys");
            if (map != null) {
                extraKeys = RlsProtoData.ExtraKeys.create((String)map.get("host"), (String)map.get("service"), (String)map.get("method"));
            }
            if ((constantKeys = JsonUtil.getObject(keyBuilder, "constantKeys")) == null) {
                constantKeys = ImmutableMap.of();
            }
            ImmutableCollection nameMatchers = nameMatchersBuilder.build();
            RlsProtoConverters.checkUniqueKey((List)((Object)nameMatchers), constantKeys.keySet());
            return RlsProtoData.GrpcKeyBuilder.create((ImmutableList<RlsProtoData.GrpcKeyBuilder.Name>)namesBuilder.build(), (ImmutableList<RlsProtoData.NameMatcher>)nameMatchers, extraKeys, ImmutableMap.copyOf(constantKeys));
        }
    }

    static final class RouteLookupConfigConverter
    extends Converter<Map<String, ?>, RlsProtoData.RouteLookupConfig> {
        RouteLookupConfigConverter() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected RlsProtoData.RouteLookupConfig doForward(Map<String, ?> json) {
            void var7_17;
            ImmutableList<RlsProtoData.GrpcKeyBuilder> grpcKeybuilders = GrpcKeyBuilderConverter.covertAll(Preconditions.checkNotNull(JsonUtil.getListOfObjects(json, "grpcKeybuilders"), "grpcKeybuilders"));
            Preconditions.checkArgument(!grpcKeybuilders.isEmpty(), "must have at least one GrpcKeyBuilder");
            HashSet<RlsProtoData.GrpcKeyBuilder.Name> names = new HashSet<RlsProtoData.GrpcKeyBuilder.Name>();
            for (RlsProtoData.GrpcKeyBuilder grpcKeyBuilder : grpcKeybuilders) {
                for (RlsProtoData.GrpcKeyBuilder.Name name : grpcKeyBuilder.names()) {
                    Preconditions.checkArgument(names.add(name), "duplicate names in grpc_keybuilders: " + name);
                }
                HashSet<String> keys = new HashSet<String>();
                for (RlsProtoData.NameMatcher header : grpcKeyBuilder.headers()) {
                    RlsProtoConverters.checkKeys(keys, header.key(), "header");
                }
                for (String key : grpcKeyBuilder.constantKeys().keySet()) {
                    RlsProtoConverters.checkKeys(keys, key, "constant");
                }
                String string = RouteLookupConfigConverter.keyToString(grpcKeyBuilder.extraKeys());
                Preconditions.checkArgument(keys.add(string), "duplicate extra key in grpc_keybuilders: " + string);
            }
            String lookupService = JsonUtil.getString(json, "lookupService");
            Preconditions.checkArgument(!Strings.isNullOrEmpty(lookupService), "lookupService must not be empty");
            try {
                URI uRI = new URI(lookupService);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new IllegalArgumentException("The lookupService field is not valid URI: " + lookupService, uRISyntaxException);
            }
            long l = RouteLookupConfigConverter.orDefault(JsonUtil.getStringAsDuration(json, "lookupServiceTimeout"), DEFAULT_LOOKUP_SERVICE_TIMEOUT);
            Preconditions.checkArgument(l > 0L, "lookupServiceTimeout should be positive");
            Long l2 = JsonUtil.getStringAsDuration(json, "maxAge");
            Long staleAge = JsonUtil.getStringAsDuration(json, "staleAge");
            if (l2 == null) {
                Preconditions.checkArgument(staleAge == null, "to specify staleAge, must have maxAge");
                Long l3 = MAX_AGE_NANOS;
            }
            if (staleAge == null) {
                staleAge = MAX_AGE_NANOS;
            }
            Long l4 = Math.min(var7_17.longValue(), MAX_AGE_NANOS);
            staleAge = Math.min(staleAge, l4);
            long cacheSize = RouteLookupConfigConverter.orDefault(JsonUtil.getNumberAsLong(json, "cacheSizeBytes"), 0x500000L);
            Preconditions.checkArgument(cacheSize > 0L, "cacheSize must be positive");
            cacheSize = Math.min(cacheSize, 0x500000L);
            String defaultTarget = Strings.emptyToNull(JsonUtil.getString(json, "defaultTarget"));
            return RlsProtoData.RouteLookupConfig.builder().grpcKeybuilders(grpcKeybuilders).lookupService(lookupService).lookupServiceTimeoutInNanos(l).maxAgeInNanos(l4).staleAgeInNanos(staleAge).cacheSizeBytes(cacheSize).defaultTarget(defaultTarget).build();
        }

        private static String keyToString(RlsProtoData.ExtraKeys extraKeys) {
            return String.format("host: %s, service: %s, method: %s", extraKeys.host(), extraKeys.service(), extraKeys.method());
        }

        private static <T> T orDefault(@Nullable T value, T defaultValue) {
            if (value == null) {
                return Preconditions.checkNotNull(defaultValue, "defaultValue");
            }
            return value;
        }

        @Override
        protected Map<String, Object> doBackward(RlsProtoData.RouteLookupConfig routeLookupConfig) {
            throw new UnsupportedOperationException();
        }
    }

    static final class RouteLookupResponseConverter
    extends Converter<RouteLookupResponse, RlsProtoData.RouteLookupResponse> {
        RouteLookupResponseConverter() {
        }

        @Override
        protected RlsProtoData.RouteLookupResponse doForward(RouteLookupResponse routeLookupResponse) {
            return RlsProtoData.RouteLookupResponse.create(ImmutableList.copyOf(routeLookupResponse.getTargetsList()), routeLookupResponse.getHeaderData());
        }

        @Override
        protected RouteLookupResponse doBackward(RlsProtoData.RouteLookupResponse routeLookupResponse) {
            return RouteLookupResponse.newBuilder().addAllTargets(routeLookupResponse.targets()).setHeaderData(routeLookupResponse.getHeaderData()).build();
        }
    }

    static final class RouteLookupRequestConverter
    extends Converter<RouteLookupRequest, RlsProtoData.RouteLookupRequest> {
        RouteLookupRequestConverter() {
        }

        @Override
        protected RlsProtoData.RouteLookupRequest doForward(RouteLookupRequest routeLookupRequest) {
            return RlsProtoData.RouteLookupRequest.create(ImmutableMap.copyOf(routeLookupRequest.getKeyMapMap()));
        }

        @Override
        protected RouteLookupRequest doBackward(RlsProtoData.RouteLookupRequest routeLookupRequest) {
            return RouteLookupRequest.newBuilder().setTargetType("grpc").putAllKeyMap(routeLookupRequest.keyMap()).build();
        }
    }
}

