/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.nessie;

import java.util.HashMap;
import java.util.Map;
import org.apache.iceberg.BaseMetastoreTableOperations;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableMetadataParser;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.CommitStateUnknownException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.nessie.NessieIcebergClient;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.projectnessie.client.api.GetContentBuilder;
import org.projectnessie.client.http.HttpClientException;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NessieTableOperations
extends BaseMetastoreTableOperations {
    private static final Logger LOG = LoggerFactory.getLogger(NessieTableOperations.class);
    public static final String NESSIE_COMMIT_ID_PROPERTY = "nessie.commit.id";
    private final NessieIcebergClient client;
    private final ContentKey key;
    private IcebergTable table;
    private final FileIO fileIO;
    private final Map<String, String> catalogOptions;

    NessieTableOperations(ContentKey key, NessieIcebergClient client, FileIO fileIO, Map<String, String> catalogOptions) {
        this.key = key;
        this.client = client;
        this.fileIO = fileIO;
        this.catalogOptions = catalogOptions;
    }

    protected String tableName() {
        return this.key.toString();
    }

    private TableMetadata loadTableMetadata(String metadataLocation, Reference reference) {
        TableMetadata deserialized = TableMetadataParser.read((FileIO)this.io(), (String)metadataLocation);
        HashMap newProperties = Maps.newHashMap((Map)deserialized.properties());
        newProperties.put(NESSIE_COMMIT_ID_PROPERTY, reference.getHash());
        newProperties.put("gc.enabled", "false");
        TableMetadata.Builder builder = TableMetadata.buildFrom((TableMetadata)deserialized).setPreviousFileLocation(null).setCurrentSchema(this.table.getSchemaId()).setDefaultSortOrder(this.table.getSortOrderId()).setDefaultPartitionSpec(this.table.getSpecId()).withMetadataLocation(metadataLocation).setProperties((Map)newProperties);
        if (this.table.getSnapshotId() != -1L) {
            builder.setBranchSnapshot(this.table.getSnapshotId(), "main");
        }
        LOG.info("loadTableMetadata for '{}' from location '{}' at '{}'", new Object[]{this.key, metadataLocation, reference});
        return builder.discardChanges().build();
    }

    protected void doRefresh() {
        Reference reference;
        String metadataLocation;
        block7: {
            try {
                this.client.refresh();
            }
            catch (NessieNotFoundException e) {
                throw new RuntimeException(String.format("Failed to refresh as ref '%s' is no longer valid.", this.client.getRef().getName()), e);
            }
            metadataLocation = null;
            reference = this.client.getRef().getReference();
            try {
                Content content = (Content)((GetContentBuilder)this.client.getApi().getContent().key(this.key).reference(reference)).get().get(this.key);
                LOG.debug("Content '{}' at '{}': {}", new Object[]{this.key, reference, content});
                if (content == null) {
                    if (this.currentMetadataLocation() != null) {
                        throw new NoSuchTableException("No such table '%s' in '%s'", new Object[]{this.key, reference});
                    }
                } else {
                    this.table = (IcebergTable)content.unwrap(IcebergTable.class).orElseThrow(() -> new IllegalStateException(String.format("Cannot refresh iceberg table: Nessie points to a non-Iceberg object for path: %s.", this.key)));
                    metadataLocation = this.table.getMetadataLocation();
                }
            }
            catch (NessieNotFoundException ex) {
                if (this.currentMetadataLocation() == null) break block7;
                throw new NoSuchTableException((Throwable)ex, "No such table '%s'", new Object[]{this.key});
            }
        }
        this.refreshFromMetadataLocation(metadataLocation, null, 2, l -> this.loadTableMetadata((String)l, reference));
    }

    protected void doCommit(TableMetadata base, TableMetadata metadata) {
        String newMetadataLocation = base == null && metadata.metadataFileLocation() != null ? metadata.metadataFileLocation() : this.writeNewMetadata(metadata, this.currentVersion() + 1);
        String refName = this.client.refName();
        boolean delete = true;
        try {
            this.client.commitTable(base, metadata, newMetadataLocation, this.table, this.key);
            delete = false;
        }
        catch (NessieConflictException ex) {
            throw new CommitFailedException((Throwable)ex, "Cannot commit: Reference hash is out of date. Update the reference '%s' and try again", new Object[]{refName});
        }
        catch (HttpClientException ex) {
            delete = false;
            throw new CommitStateUnknownException((Throwable)ex);
        }
        catch (NessieNotFoundException ex) {
            throw new RuntimeException(String.format("Cannot commit: Reference '%s' no longer exists", refName), ex);
        }
        finally {
            if (delete) {
                this.io().deleteFile(newMetadataLocation);
            }
        }
    }

    public FileIO io() {
        return this.fileIO;
    }
}

