/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.compute.gridify.aop.spring;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteState;
import org.apache.ignite.compute.ComputeTask;
import org.apache.ignite.compute.gridify.Gridify;
import org.apache.ignite.compute.gridify.GridifyArgument;
import org.apache.ignite.compute.gridify.GridifyInterceptor;
import org.apache.ignite.compute.gridify.GridifyRuntimeException;
import org.apache.ignite.compute.gridify.aop.GridifyArgumentAdapter;
import org.apache.ignite.compute.gridify.aop.GridifyDefaultTask;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.G;

public class GridifySpringAspect
implements MethodInterceptor {
    public Object invoke(MethodInvocation invoc) throws Throwable {
        String gridName;
        Method mtd = invoc.getMethod();
        Gridify ann = mtd.getAnnotation(Gridify.class);
        assert (ann != null) : "Intercepted method does not have gridify annotation.";
        String string = gridName = F.isEmpty((String)ann.gridName()) ? null : ann.gridName();
        if (G.state((String)gridName) != IgniteState.STARTED) {
            throw new IgniteCheckedException("Grid is not locally started: " + gridName);
        }
        GridifyArgumentAdapter arg = new GridifyArgumentAdapter(mtd.getDeclaringClass(), mtd.getName(), (Class[])mtd.getParameterTypes(), invoc.getArguments(), invoc.getThis());
        if (!ann.interceptor().equals(GridifyInterceptor.class) && !((GridifyInterceptor)ann.interceptor().newInstance()).isGridify((Annotation)ann, (GridifyArgument)arg)) {
            return invoc.proceed();
        }
        if (!ann.taskClass().equals(GridifyDefaultTask.class) && !ann.taskName().isEmpty()) {
            throw new IgniteCheckedException("Gridify annotation must specify either Gridify.taskName() or Gridify.taskClass(), but not both: " + ann);
        }
        try {
            Ignite ignite = G.ignite((String)gridName);
            if (!ann.taskClass().equals(GridifyDefaultTask.class)) {
                return ignite.compute().withTimeout(ann.timeout()).execute(ann.taskClass(), (Object)arg);
            }
            if (ann.taskName().isEmpty()) {
                return ignite.compute().withTimeout(ann.timeout()).execute((ComputeTask)new GridifyDefaultTask(invoc.getMethod().getDeclaringClass()), (Object)arg);
            }
            return ignite.compute().withTimeout(ann.timeout()).execute(ann.taskName(), (Object)arg);
        }
        catch (Throwable e) {
            for (Class<?> ex : invoc.getMethod().getExceptionTypes()) {
                for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                    if (!ex.isAssignableFrom(cause.getClass())) continue;
                    throw cause;
                }
                if (!ex.isAssignableFrom(e.getClass())) continue;
                throw e;
            }
            throw new GridifyRuntimeException("Undeclared exception thrown: " + e.getMessage(), e);
        }
    }
}

