/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2ProxyIndex;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAggregateFunction;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAlias;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlArray;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAst;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlColumn;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlConst;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlElement;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlFunction;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlJoin;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlOperation;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlOperationType;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlQuery;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlSelect;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlSubquery;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlTable;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlUnion;
import org.apache.ignite.internal.util.typedef.F;
import org.h2.index.Index;
import org.jetbrains.annotations.Nullable;

public class GridSubqueryJoinOptimizer {
    private static final BiPredicate<GridSqlAst, GridSqlAst> ELEMENT_WITH_SUBQUERY = (parent, child) -> child instanceof GridSqlSubquery;
    private static final BiPredicate<GridSqlAst, GridSqlAst> ELEMENT_WITH_SUBQUERY_WITHIN_IN_EXPRESSION = (parent, child) -> child instanceof GridSqlOperation && ((GridSqlOperation)child).operationType() == GridSqlOperationType.IN && child.child(1) instanceof GridSqlSubquery;
    private static final BiPredicate<GridSqlAst, GridSqlAst> ELEMENT_WITH_SUBQUERY_WITHIN_EXISTS_EXPRESSION = (parent, child) -> child instanceof GridSqlOperation && ((GridSqlOperation)child).operationType() == GridSqlOperationType.EXISTS && child.child() instanceof GridSqlSubquery;
    private static final Predicate<GridSqlAst> ELEMENT_IS_AND_OPERATION = elem -> elem instanceof GridSqlOperation && ((GridSqlOperation)elem).operationType() == GridSqlOperationType.AND;
    private static final BiPredicate<GridSqlAst, GridSqlAst> ELEMENT_WITH_ALIAS_WITH_SUBQUERY = (parent, child) -> child instanceof GridSqlAlias && child.child() instanceof GridSqlSubquery;
    private static final Predicate<GridSqlAst> ELEMENT_IS_JOIN = elem -> elem instanceof GridSqlJoin;
    private static final Predicate<GridSqlAst> ELEMENT_IS_EQ = elem -> elem instanceof GridSqlOperation && (GridSqlOperationType.EQUAL == ((GridSqlOperation)elem).operationType() || GridSqlOperationType.EQUAL_NULL_SAFE == ((GridSqlOperation)elem).operationType());
    private static volatile Boolean optimizationEnabled;

    private static boolean optimizationEnabled() {
        if (optimizationEnabled == null) {
            optimizationEnabled = Boolean.parseBoolean(System.getProperty("IGNITE_ENABLE_SUBQUERY_REWRITE_OPTIMIZATION", "true"));
        }
        return optimizationEnabled;
    }

    public static void pullOutSubQueries(GridSqlQuery parent) {
        if (!GridSubqueryJoinOptimizer.optimizationEnabled()) {
            return;
        }
        if (parent instanceof GridSqlUnion) {
            GridSqlUnion union = (GridSqlUnion)parent;
            GridSubqueryJoinOptimizer.pullOutSubQueries(union.left());
            GridSubqueryJoinOptimizer.pullOutSubQueries(union.right());
            return;
        }
        assert (parent instanceof GridSqlSelect) : "\"parent\" should be instance of GridSqlSelect class";
        GridSqlSelect select = (GridSqlSelect)parent;
        GridSubqueryJoinOptimizer.pullOutSubQryFromSelectExpr(select);
        GridSubqueryJoinOptimizer.pullOutSubQryFromInClause(select);
        GridSubqueryJoinOptimizer.pullOutSubQryFromExistsClause(select);
        GridSubqueryJoinOptimizer.pullOutSubQryFromTableList(select);
    }

    private static void pullOutSubQryFromSelectExpr(GridSqlSelect select) {
        for (int i = 0; i < select.allColumns(); ++i) {
            boolean wasPulledOut = false;
            GridSqlAst col = select.columns(false).get(i);
            if (col instanceof GridSqlSubquery) {
                wasPulledOut = GridSubqueryJoinOptimizer.pullOutSubQryFromSelectExpr(select, null, i);
            } else {
                ASTNodeFinder.Result res;
                if (col instanceof GridSqlOperation && ((GridSqlOperation)col).operationType() == GridSqlOperationType.EXISTS) continue;
                ASTNodeFinder finder = new ASTNodeFinder(col, ELEMENT_WITH_SUBQUERY);
                while ((res = finder.findNext()) != null) {
                    wasPulledOut |= GridSubqueryJoinOptimizer.pullOutSubQryFromSelectExpr(select, res.getEl(), res.getIdx());
                }
            }
            if (!wasPulledOut) continue;
            --i;
        }
    }

    private static void pullOutSubQryFromTableList(GridSqlSelect select) {
        boolean wasPulledOut;
        do {
            ASTNodeFinder.Result res;
            wasPulledOut = false;
            if (ELEMENT_WITH_ALIAS_WITH_SUBQUERY.test(null, select.from())) {
                wasPulledOut = GridSubqueryJoinOptimizer.pullOutSubQryFromTableList(select, null, -1);
                continue;
            }
            if (!ELEMENT_IS_JOIN.test(select.from())) continue;
            ASTNodeFinder finder = new ASTNodeFinder(select.from(), ELEMENT_WITH_ALIAS_WITH_SUBQUERY, ELEMENT_IS_JOIN);
            while ((res = finder.findNext()) != null) {
                wasPulledOut |= GridSubqueryJoinOptimizer.pullOutSubQryFromTableList(select, res.getEl(), res.getIdx());
            }
        } while (wasPulledOut);
    }

    private static void pullOutSubQryFromInClause(GridSqlSelect select) {
        boolean wasPulledOut;
        if (ELEMENT_WITH_SUBQUERY_WITHIN_IN_EXPRESSION.test(null, select.where())) {
            GridSubqueryJoinOptimizer.pullOutSubQryFromInClause(select, null, -1);
        }
        if (!ELEMENT_IS_AND_OPERATION.test(select.where())) {
            return;
        }
        do {
            ASTNodeFinder.Result res;
            wasPulledOut = false;
            ASTNodeFinder finder = new ASTNodeFinder(select.where(), ELEMENT_WITH_SUBQUERY_WITHIN_IN_EXPRESSION, ELEMENT_IS_AND_OPERATION);
            while ((res = finder.findNext()) != null) {
                wasPulledOut |= GridSubqueryJoinOptimizer.pullOutSubQryFromInClause(select, res.getEl(), res.getIdx());
            }
        } while (wasPulledOut);
    }

    private static void pullOutSubQryFromExistsClause(GridSqlSelect select) {
        boolean wasPulledOut;
        if (ELEMENT_WITH_SUBQUERY_WITHIN_EXISTS_EXPRESSION.test(null, select.where())) {
            GridSubqueryJoinOptimizer.pullOutSubQryFromExistsClause(select, null, -1);
        }
        if (!ELEMENT_IS_AND_OPERATION.test(select.where())) {
            return;
        }
        do {
            ASTNodeFinder.Result res;
            wasPulledOut = false;
            ASTNodeFinder finder = new ASTNodeFinder(select.where(), ELEMENT_WITH_SUBQUERY_WITHIN_EXISTS_EXPRESSION, ELEMENT_IS_AND_OPERATION);
            while ((res = finder.findNext()) != null) {
                wasPulledOut |= GridSubqueryJoinOptimizer.pullOutSubQryFromExistsClause(select, res.getEl(), res.getIdx());
            }
        } while (wasPulledOut);
    }

    private static boolean isSimpleSelect(GridSqlQuery subQry) {
        boolean simple;
        if (subQry instanceof GridSqlUnion) {
            return false;
        }
        GridSqlSelect select = (GridSqlSelect)subQry;
        boolean bl = simple = F.isEmpty(select.sort()) && select.offset() == null && select.limit() == null && !select.isForUpdate() && !select.distinct() && select.havingColumn() < 0 && F.isEmpty((int[])select.groupColumns());
        if (!simple) {
            return false;
        }
        for (GridSqlAst col : select.columns(true)) {
            if (!(col instanceof GridSqlElement)) continue;
            ASTNodeFinder aggFinder = new ASTNodeFinder(col, (p, c) -> p instanceof GridSqlAggregateFunction);
            if (aggFinder.findNext() != null) {
                return false;
            }
            ASTNodeFinder operationFinder = new ASTNodeFinder(col, (p, c) -> p instanceof GridSqlOperation, ast -> false);
            if (operationFinder.findNext() == null) continue;
            return false;
        }
        return true;
    }

    private static boolean isUniqueIndexExists(Collection<GridSqlColumn> gridCols, GridSqlTable tbl) {
        Set cols = gridCols.stream().map(GridSqlColumn::column).collect(Collectors.toSet());
        for (Index idx : tbl.dataTable().getIndexes()) {
            if (!idx.getIndexType().isUnique() && (!(idx instanceof GridH2ProxyIndex) || !((GridH2ProxyIndex)idx).underlyingIndex().getIndexType().isUnique()) || !cols.containsAll(Arrays.asList(idx.getColumns()))) continue;
            return true;
        }
        return false;
    }

    private static boolean pullOutSubQryFromTableList(GridSqlSelect parent, @Nullable GridSqlAst target, int childInd) {
        if (target != null && !ELEMENT_IS_JOIN.test(target)) {
            return false;
        }
        GridSqlAlias wrappedSubQry = target != null ? (GridSqlAlias)target.child(childInd) : (GridSqlAlias)parent.from();
        GridSqlSubquery subQry = (GridSqlSubquery)GridSqlAlias.unwrap(wrappedSubQry);
        if (!GridSubqueryJoinOptimizer.isSimpleSelect(subQry.subquery())) {
            return false;
        }
        GridSqlSelect subSel = (GridSqlSelect)subQry.subquery();
        if (!(subSel.from() instanceof GridSqlAlias) && !(subSel.from() instanceof GridSqlTable)) {
            return false;
        }
        GridSqlAlias subTbl = new GridSqlAlias(wrappedSubQry.alias(), (GridSqlAst)GridSqlAlias.unwrap(subSel.from()));
        if (target == null) {
            parent.from(subTbl);
        } else {
            target.child(childInd, subTbl);
        }
        GridSqlAst where = subSel.where();
        if (where != null) {
            if (target instanceof GridSqlJoin && childInd != 0) {
                GridSqlJoin join = (GridSqlJoin)target;
                join.child(2, new GridSqlOperation(GridSqlOperationType.AND, join.on(), where));
            } else {
                parent.where(parent.where() == null ? where : new GridSqlOperation(GridSqlOperationType.AND, parent.where(), where));
            }
        }
        GridSubqueryJoinOptimizer.remapColumns(parent, subSel, col -> wrappedSubQry == col.expressionInFrom(), subTbl);
        return true;
    }

    private static void remapColumns(GridSqlAst parent, GridSqlAst subSelect, Predicate<GridSqlColumn> colPred, GridSqlAlias tbl) {
        ASTNodeFinder.Result res;
        ASTNodeFinder colFinder = new ASTNodeFinder(parent, (p, c) -> c instanceof GridSqlColumn && colPred.test((GridSqlColumn)c));
        while ((res = colFinder.findNext()) != null) {
            BiPredicate<GridSqlAst, GridSqlAst> aliasPred;
            GridSqlColumn oldCol = (GridSqlColumn)res.getEl().child(res.getIdx());
            BiPredicate<GridSqlAst, GridSqlAst> constPred = (p, c) -> c != null && c.getSQL().equals(oldCol.columnName());
            ASTNodeFinder.Result aliasOrPred = GridSubqueryJoinOptimizer.findNode(subSelect, constPred.or(aliasPred = (p, c) -> c instanceof GridSqlAlias && ((GridSqlAlias)c).alias().equals(oldCol.columnName())));
            if (aliasOrPred != null) {
                res.getEl().child(res.getIdx(), GridSqlAlias.unwrap(aliasOrPred.getEl().child(aliasOrPred.getIdx())));
                continue;
            }
            res.getEl().child(res.getIdx(), new GridSqlColumn(oldCol.column(), tbl, oldCol.schema(), tbl.alias(), oldCol.columnName()));
        }
    }

    private static ASTNodeFinder.Result findNode(GridSqlAst tree, BiPredicate<GridSqlAst, GridSqlAst> pred) {
        ASTNodeFinder colFinder = new ASTNodeFinder(tree, pred);
        return colFinder.findNext();
    }

    private static boolean pullOutSubQryFromSelectExpr(GridSqlSelect parent, @Nullable GridSqlAst targetEl, int childInd) {
        GridSqlSubquery subQry;
        GridSqlSubquery gridSqlSubquery = subQry = targetEl != null ? (GridSqlSubquery)targetEl.child(childInd) : (GridSqlSubquery)parent.columns(false).get(childInd);
        if (!GridSubqueryJoinOptimizer.subQueryCanBePulledOut(subQry)) {
            return false;
        }
        GridSqlSelect subS = (GridSqlSelect)subQry.subquery();
        if (subS.allColumns() != 1) {
            return false;
        }
        Object subCol = GridSqlAlias.unwrap(subS.columns(false).get(0));
        if (subCol instanceof GridSqlConst) {
            return false;
        }
        if (targetEl != null) {
            targetEl.child(childInd, subCol);
        } else {
            parent.setColumn(childInd, (GridSqlAst)subCol);
        }
        GridSqlElement parentFrom = parent.from() instanceof GridSqlElement ? (GridSqlElement)parent.from() : new GridSqlSubquery((GridSqlQuery)parent.from());
        parent.from(new GridSqlJoin(parentFrom, (GridSqlElement)GridSqlAlias.unwrap(subS.from()), true, (GridSqlElement)subS.where())).child();
        return true;
    }

    private static boolean pullOutSubQryFromInClause(GridSqlSelect parent, @Nullable GridSqlAst targetEl, int childInd) {
        Object leftExpr;
        GridSqlSubquery subQry;
        GridSqlSubquery gridSqlSubquery = subQry = targetEl != null ? (GridSqlSubquery)targetEl.child(childInd).child(1) : (GridSqlSubquery)parent.where().child(1);
        if (!GridSubqueryJoinOptimizer.isSimpleSelect(subQry.subquery())) {
            return false;
        }
        GridSqlSelect subS = (GridSqlSelect)subQry.subquery();
        Object e = leftExpr = targetEl != null ? targetEl.child(childInd).child(0) : parent.where().child(0);
        if (subS.visibleColumns() != 1) {
            return false;
        }
        ArrayList<GridSqlElement> conditions = new ArrayList<GridSqlElement>();
        if (leftExpr instanceof GridSqlArray) {
            GridSqlAst col = subS.columns(true).get(0);
            if (!(col instanceof GridSqlArray) || leftExpr.size() != col.size()) {
                return false;
            }
            for (int i = 0; i < col.size(); ++i) {
                GridSqlElement el = (GridSqlElement)leftExpr.child(i);
                conditions.add(new GridSqlOperation(GridSqlOperationType.EQUAL, el, (GridSqlAst)col.child(i)));
            }
        } else {
            if (targetEl instanceof GridSqlFunction) {
                return false;
            }
            conditions.add(new GridSqlOperation(GridSqlOperationType.EQUAL, (GridSqlAst)leftExpr, subS.columns(true).get(0)));
        }
        GridSqlElement oldCond = (GridSqlElement)subS.where();
        if (oldCond != null) {
            conditions.add(oldCond);
        }
        GridSqlElement oldInExpr = targetEl != null ? (GridSqlElement)targetEl.child(childInd) : (GridSqlElement)parent.where();
        subS.where(GridSubqueryJoinOptimizer.buildConditionBush(conditions));
        GridSqlOperation existsExpr = new GridSqlOperation(GridSqlOperationType.EXISTS, subQry);
        if (targetEl != null) {
            targetEl.child(childInd, existsExpr);
        } else {
            parent.where(existsExpr);
        }
        boolean res = GridSubqueryJoinOptimizer.pullOutSubQryFromExistsClause(parent, targetEl, childInd);
        if (!res) {
            if (targetEl != null) {
                targetEl.child(childInd, oldInExpr);
            } else {
                parent.where(oldInExpr);
            }
            subS.where(oldCond);
        }
        return res;
    }

    private static GridSqlElement buildConditionBush(List<GridSqlElement> ops) {
        assert (!F.isEmpty(ops));
        if (ops.size() == 1) {
            return ops.get(0);
        }
        int m = (ops.size() + 1) / 2;
        GridSqlElement left = GridSubqueryJoinOptimizer.buildConditionBush(ops.subList(0, m));
        GridSqlElement right = GridSubqueryJoinOptimizer.buildConditionBush(ops.subList(m, ops.size()));
        return new GridSqlOperation(GridSqlOperationType.AND, left, right);
    }

    private static boolean pullOutSubQryFromExistsClause(GridSqlSelect parent, @Nullable GridSqlAst targetEl, int childInd) {
        GridSqlSubquery subQry;
        GridSqlSubquery gridSqlSubquery = subQry = targetEl != null ? (GridSqlSubquery)targetEl.child(childInd).child() : (GridSqlSubquery)parent.where().child();
        if (!GridSubqueryJoinOptimizer.subQueryCanBePulledOut(subQry)) {
            return false;
        }
        GridSqlSelect subS = (GridSqlSelect)subQry.subquery();
        if (targetEl != null) {
            targetEl.child(childInd, subS.where());
        } else {
            parent.where(subS.where());
        }
        GridSqlElement parentFrom = parent.from() instanceof GridSqlElement ? (GridSqlElement)parent.from() : new GridSqlSubquery((GridSqlQuery)parent.from());
        parent.from(new GridSqlJoin(parentFrom, (GridSqlElement)GridSqlAlias.unwrap(subS.from()), false, null)).child();
        return true;
    }

    private static boolean subQueryCanBePulledOut(GridSqlSubquery subQry) {
        ASTNodeFinder.Result res;
        Object subQ = subQry.subquery();
        if (!GridSubqueryJoinOptimizer.isSimpleSelect(subQ)) {
            return false;
        }
        assert (subQ instanceof GridSqlSelect);
        GridSqlSelect subS = (GridSqlSelect)subQ;
        if (subS.where() == null) {
            return false;
        }
        Predicate<GridSqlAst> andOrEqPre = ELEMENT_IS_AND_OPERATION.or(ELEMENT_IS_EQ);
        if (!andOrEqPre.test(subS.where())) {
            return false;
        }
        ASTNodeFinder opEqFinder = new ASTNodeFinder(subS.where(), (parent, child) -> ELEMENT_IS_EQ.test((GridSqlAst)parent), andOrEqPre);
        ArrayList<GridSqlColumn> sqlCols = new ArrayList<GridSqlColumn>();
        while ((res = opEqFinder.findNext()) != null) {
            GridSqlOperation op = (GridSqlOperation)res.getEl();
            assert (op.size() == 2);
            GridSqlColumn[] colArr = new GridSqlColumn[2];
            for (int i = 0; i < 2; ++i) {
                if (op.child(i) instanceof GridSqlColumn) {
                    colArr[i] = (GridSqlColumn)op.child(i);
                    continue;
                }
                if (!(op.child(i) instanceof GridSqlOperation) || ((GridSqlOperation)op.child(i)).operationType() != GridSqlOperationType.NEGATE || !(op.child() instanceof GridSqlColumn)) continue;
                colArr[i] = (GridSqlColumn)op.child(i).child();
            }
            if (colArr[0] != null && colArr[1] != null && colArr[0].expressionInFrom() == colArr[1].expressionInFrom()) continue;
            if (colArr[0] != null && colArr[0].expressionInFrom() == subS.from()) {
                sqlCols.add(colArr[0]);
            }
            if (colArr[1] == null || colArr[1].expressionInFrom() != subS.from()) continue;
            sqlCols.add(colArr[1]);
        }
        Object subTbl = GridSqlAlias.unwrap(subS.from());
        return subTbl instanceof GridSqlTable && GridSubqueryJoinOptimizer.isUniqueIndexExists(sqlCols, (GridSqlTable)subTbl);
    }

    private static class ASTNodeFinder {
        private final List<ChildrenIterator> iterStack = new ArrayList<ChildrenIterator>();
        private final BiPredicate<GridSqlAst, GridSqlAst> emitPred;
        private final Predicate<GridSqlAst> walkPred;

        private ASTNodeFinder(GridSqlAst root, BiPredicate<GridSqlAst, GridSqlAst> emitPred, Predicate<GridSqlAst> walkPred) {
            assert (root != null) : "root";
            assert (emitPred != null) : "emitPredicate";
            assert (walkPred != null) : "walkPred";
            this.emitPred = emitPred;
            this.walkPred = walkPred;
            this.iterStack.add(new ChildrenIterator(root));
        }

        ASTNodeFinder(GridSqlAst root, BiPredicate<GridSqlAst, GridSqlAst> emitPred) {
            this.emitPred = emitPred;
            this.walkPred = child -> child instanceof GridSqlElement;
            this.iterStack.add(new ChildrenIterator(root));
        }

        Result findNext() {
            while (!this.iterStack.isEmpty()) {
                ChildrenIterator childrenIter = this.iterStack.get(this.iterStack.size() - 1);
                GridSqlAst curChild = childrenIter.nextChild();
                if (curChild == null) {
                    this.iterStack.remove(this.iterStack.size() - 1);
                }
                if (this.walkPred.test(curChild)) {
                    this.iterStack.add(new ChildrenIterator(curChild));
                }
                if (!this.emitPred.test(childrenIter.el, curChild)) continue;
                return new Result(childrenIter.childInd, childrenIter.el);
            }
            return null;
        }

        private static class Result {
            private final int idx;
            private final GridSqlAst el;

            private Result(int idx, GridSqlAst el) {
                this.idx = idx;
                this.el = el;
            }

            public int getIdx() {
                return this.idx;
            }

            public GridSqlAst getEl() {
                return this.el;
            }
        }

        private static class ChildrenIterator {
            private int childInd;
            private final GridSqlAst el;

            private ChildrenIterator(GridSqlAst el) {
                this.el = el;
                this.childInd = -1;
            }

            private GridSqlAst nextChild() {
                if (++this.childInd < this.el.size()) {
                    return this.el.child(this.childInd);
                }
                return null;
            }
        }
    }
}

