/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.dml;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.h2.dml.FastUpdate;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RowDescriptor;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAlias;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlArray;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAst;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlColumn;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlConst;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlDelete;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlElement;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlFunction;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlFunctionType;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlJoin;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlKeyword;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlOperation;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlOperationType;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlParameter;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlQuery;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlSelect;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlSubquery;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlTable;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlType;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlUnion;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlUpdate;
import org.apache.ignite.internal.util.lang.IgnitePair;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.h2.command.Parser;
import org.h2.expression.Expression;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.util.IntArray;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueDate;
import org.h2.value.ValueInt;
import org.h2.value.ValueString;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;
import org.jetbrains.annotations.Nullable;

public final class DmlAstUtils {
    private DmlAstUtils() {
    }

    public static GridSqlQuery selectForInsertOrMerge(GridSqlColumn[] cols, List<GridSqlElement[]> rows, GridSqlQuery subQry) {
        if (!F.isEmpty(rows)) {
            assert (!F.isEmpty((Object[])cols));
            GridSqlSelect sel = new GridSqlSelect();
            GridSqlFunction from = new GridSqlFunction(GridSqlFunctionType.TABLE);
            sel.from(from);
            GridSqlArray[] args = new GridSqlArray[cols.length];
            for (int i = 0; i < cols.length; ++i) {
                GridSqlArray arr = new GridSqlArray(rows.size());
                String colName = cols[i].columnName();
                GridSqlAlias alias = new GridSqlAlias(colName, arr);
                alias.resultType(cols[i].resultType());
                from.addChild(alias);
                args[i] = arr;
                GridSqlColumn newCol = new GridSqlColumn(null, from, null, "TABLE", colName);
                newCol.resultType(cols[i].resultType());
                sel.addColumn(newCol, true);
            }
            for (GridSqlElement[] row : rows) {
                assert (cols.length == row.length);
                for (int i = 0; i < row.length; ++i) {
                    args[i].addChild(row[i]);
                }
            }
            return sel;
        }
        assert (subQry != null);
        return subQry;
    }

    public static GridSqlSelect selectForDelete(GridSqlDelete del, @Nullable Integer keysParamIdx) {
        GridSqlSelect mapQry = new GridSqlSelect();
        mapQry.from(del.from());
        HashSet<GridSqlTable> tbls = new HashSet<GridSqlTable>();
        DmlAstUtils.collectAllGridTablesInTarget(del.from(), tbls);
        assert (tbls.size() == 1) : "Failed to determine target table for DELETE";
        GridSqlTable tbl = (GridSqlTable)tbls.iterator().next();
        GridH2Table gridTbl = tbl.dataTable();
        assert (gridTbl != null) : "Failed to determine target grid table for DELETE";
        Column h2KeyCol = gridTbl.getColumn(0);
        Column h2ValCol = gridTbl.getColumn(1);
        GridSqlColumn keyCol = new GridSqlColumn(h2KeyCol, tbl, h2KeyCol.getName());
        keyCol.resultType(GridSqlType.fromColumn(h2KeyCol));
        GridSqlColumn valCol = new GridSqlColumn(h2ValCol, tbl, h2ValCol.getName());
        valCol.resultType(GridSqlType.fromColumn(h2ValCol));
        mapQry.addColumn(keyCol, true);
        mapQry.addColumn(valCol, true);
        GridSqlElement where = del.where();
        if (keysParamIdx != null) {
            where = DmlAstUtils.injectKeysFilterParam(where, keyCol, keysParamIdx);
        }
        mapQry.where(where);
        mapQry.limit(del.limit());
        return mapQry;
    }

    public static FastUpdate getFastUpdateArgs(GridSqlUpdate update) {
        IgnitePair<GridSqlElement> filter = DmlAstUtils.findKeyValueEqualityCondition(update.where());
        if (filter == null) {
            return null;
        }
        if (update.cols().size() != 1) {
            return null;
        }
        Table tbl = update.cols().get(0).column().getTable();
        if (!(tbl instanceof GridH2Table)) {
            return null;
        }
        GridH2RowDescriptor desc = ((GridH2Table)tbl).rowDescriptor();
        if (!desc.isValueColumn(update.cols().get(0).column().getColumnId())) {
            return null;
        }
        GridSqlElement set = update.set().get(update.cols().get(0).columnName());
        if (!(set instanceof GridSqlConst) && !(set instanceof GridSqlParameter)) {
            return null;
        }
        return FastUpdate.create((GridSqlElement)filter.getKey(), (GridSqlElement)filter.getValue(), set);
    }

    public static FastUpdate getFastDeleteArgs(GridSqlDelete del) {
        IgnitePair<GridSqlElement> filter = DmlAstUtils.findKeyValueEqualityCondition(del.where());
        if (filter == null) {
            return null;
        }
        return FastUpdate.create((GridSqlElement)filter.getKey(), (GridSqlElement)filter.getValue(), null);
    }

    private static IgnitePair<GridSqlElement> findKeyValueEqualityCondition(GridSqlElement where) {
        if (where == null || !(where instanceof GridSqlOperation)) {
            return null;
        }
        GridSqlOperation whereOp = (GridSqlOperation)where;
        if (DmlAstUtils.isKeyEqualityCondition(whereOp)) {
            return new IgnitePair((Object)((GridSqlElement)whereOp.child(1)), null);
        }
        if (whereOp.operationType() != GridSqlOperationType.AND) {
            return null;
        }
        GridSqlElement left = (GridSqlElement)whereOp.child(0);
        GridSqlElement right = (GridSqlElement)whereOp.child(1);
        if (!(left instanceof GridSqlOperation) || !(right instanceof GridSqlOperation)) {
            return null;
        }
        GridSqlOperation leftOp = (GridSqlOperation)left;
        GridSqlOperation rightOp = (GridSqlOperation)right;
        if (DmlAstUtils.isKeyEqualityCondition(leftOp)) {
            if (!DmlAstUtils.isValueEqualityCondition(rightOp)) {
                return null;
            }
            return new IgnitePair((Object)((GridSqlElement)leftOp.child(1)), (Object)((GridSqlElement)rightOp.child(1)));
        }
        if (DmlAstUtils.isKeyEqualityCondition(rightOp)) {
            if (!DmlAstUtils.isValueEqualityCondition(leftOp)) {
                return null;
            }
            return new IgnitePair((Object)((GridSqlElement)rightOp.child(1)), (Object)((GridSqlElement)leftOp.child(1)));
        }
        return null;
    }

    private static boolean isEqualityCondition(GridSqlOperation op, boolean key) {
        if (op.operationType() != GridSqlOperationType.EQUAL) {
            return false;
        }
        GridSqlElement left = (GridSqlElement)op.child(0);
        GridSqlElement right = (GridSqlElement)op.child(1);
        if (!(left instanceof GridSqlColumn)) {
            return false;
        }
        GridSqlColumn column = (GridSqlColumn)left;
        if (!(column.column().getTable() instanceof GridH2Table)) {
            return false;
        }
        GridH2RowDescriptor desc = ((GridH2Table)column.column().getTable()).rowDescriptor();
        return (key ? desc.isKeyColumn(column.column().getColumnId()) : desc.isValueColumn(column.column().getColumnId())) && (right instanceof GridSqlConst || right instanceof GridSqlParameter);
    }

    private static boolean isKeyEqualityCondition(GridSqlOperation op) {
        return DmlAstUtils.isEqualityCondition(op, true);
    }

    private static boolean isValueEqualityCondition(GridSqlOperation op) {
        return DmlAstUtils.isEqualityCondition(op, false);
    }

    public static GridSqlSelect selectForUpdate(GridSqlUpdate update, @Nullable Integer keysParamIdx) {
        GridSqlSelect mapQry = new GridSqlSelect();
        mapQry.from(update.target());
        HashSet<GridSqlTable> tbls = new HashSet<GridSqlTable>();
        DmlAstUtils.collectAllGridTablesInTarget(update.target(), tbls);
        assert (tbls.size() == 1) : "Failed to determine target table for UPDATE";
        GridSqlTable tbl = (GridSqlTable)tbls.iterator().next();
        GridH2Table gridTbl = tbl.dataTable();
        assert (gridTbl != null) : "Failed to determine target grid table for UPDATE";
        Column h2KeyCol = gridTbl.getColumn(0);
        Column h2ValCol = gridTbl.getColumn(1);
        GridSqlColumn keyCol = new GridSqlColumn(h2KeyCol, tbl, h2KeyCol.getName());
        keyCol.resultType(GridSqlType.fromColumn(h2KeyCol));
        GridSqlColumn valCol = new GridSqlColumn(h2ValCol, tbl, h2ValCol.getName());
        valCol.resultType(GridSqlType.fromColumn(h2ValCol));
        mapQry.addColumn(keyCol, true);
        mapQry.addColumn(valCol, true);
        for (GridSqlColumn c : update.cols()) {
            String newColName = Parser.quoteIdentifier((String)("_upd_" + c.columnName()));
            GridSqlAlias alias = new GridSqlAlias(newColName, DmlAstUtils.elementOrDefault(update.set().get(c.columnName()), c), true);
            alias.resultType(c.resultType());
            mapQry.addColumn(alias, true);
        }
        GridSqlElement where = update.where();
        if (keysParamIdx != null) {
            where = DmlAstUtils.injectKeysFilterParam(where, keyCol, keysParamIdx);
        }
        mapQry.where(where);
        mapQry.limit(update.limit());
        return mapQry;
    }

    private static GridSqlElement elementOrDefault(GridSqlElement el, GridSqlColumn col) {
        Object dfltVal;
        if (el == null) {
            return GridSqlConst.NULL;
        }
        if (el != GridSqlKeyword.DEFAULT) {
            return el;
        }
        Column h2Col = col.column();
        Expression dfltExpr = h2Col.getDefaultExpression();
        try {
            dfltVal = dfltExpr != null ? dfltExpr.getValue(null) : null;
        }
        catch (Exception ignored) {
            throw new IgniteSQLException("Failed to evaluate default value for a column " + col.columnName());
        }
        if (dfltVal != null) {
            return new GridSqlConst((Value)dfltVal);
        }
        int type = h2Col.getType();
        DataType dt = DataType.getDataType((int)type);
        dfltVal = dt.decimal ? ValueInt.get((int)0).convertTo(type) : (dt.type == 11 ? ValueTimestamp.fromMillis((long)U.currentTimeMillis()) : (dt.type == 9 ? ValueTime.fromNanos((long)0L) : (dt.type == 10 ? ValueDate.fromMillis((long)U.currentTimeMillis()) : ValueString.get((String)"").convertTo(type))));
        return new GridSqlConst((Value)dfltVal);
    }

    private static GridSqlElement injectKeysFilterParam(GridSqlElement where, GridSqlColumn keyCol, int paramIdx) {
        GridSqlSelect sel = new GridSqlSelect();
        GridSqlFunction from = new GridSqlFunction(GridSqlFunctionType.TABLE);
        sel.from(from);
        GridSqlColumn col = new GridSqlColumn(null, from, null, "TABLE", "_IGNITE_ERR_KEYS");
        sel.addColumn(col, true);
        GridSqlAlias alias = new GridSqlAlias("_IGNITE_ERR_KEYS", new GridSqlParameter(paramIdx));
        alias.resultType(keyCol.resultType());
        from.addChild(alias);
        GridSqlOperation e = new GridSqlOperation(GridSqlOperationType.IN, keyCol, new GridSqlSubquery(sel));
        if (where == null) {
            return e;
        }
        return new GridSqlOperation(GridSqlOperationType.AND, where, e);
    }

    private static List<Object> findParams(GridSqlQuery qry, Object[] params, ArrayList<Object> target, IntArray paramIdxs) {
        if (qry instanceof GridSqlSelect) {
            return DmlAstUtils.findParams((GridSqlSelect)qry, params, target, paramIdxs);
        }
        GridSqlUnion union = (GridSqlUnion)qry;
        DmlAstUtils.findParams(union.left(), params, target, paramIdxs);
        DmlAstUtils.findParams(union.right(), params, target, paramIdxs);
        DmlAstUtils.findParams((GridSqlElement)qry.limit(), params, target, paramIdxs);
        DmlAstUtils.findParams((GridSqlElement)qry.offset(), params, target, paramIdxs);
        return target;
    }

    private static List<Object> findParams(GridSqlSelect qry, Object[] params, ArrayList<Object> target, IntArray paramIdxs) {
        if (params.length == 0) {
            return target;
        }
        for (GridSqlAst el : qry.columns(false)) {
            DmlAstUtils.findParams((GridSqlElement)el, params, target, paramIdxs);
        }
        DmlAstUtils.findParams((GridSqlElement)qry.from(), params, target, paramIdxs);
        DmlAstUtils.findParams((GridSqlElement)qry.where(), params, target, paramIdxs);
        DmlAstUtils.findParams((GridSqlElement)qry.limit(), params, target, paramIdxs);
        DmlAstUtils.findParams((GridSqlElement)qry.offset(), params, target, paramIdxs);
        return target;
    }

    private static void findParams(@Nullable GridSqlElement el, Object[] params, ArrayList<Object> target, IntArray paramIdxs) {
        if (el == null) {
            return;
        }
        if (el instanceof GridSqlParameter) {
            int idx = ((GridSqlParameter)el).index();
            while (target.size() < idx) {
                target.add(null);
            }
            if (params.length <= idx) {
                throw new IgniteException("Invalid number of query parameters. Cannot find " + idx + " parameter.");
            }
            Object param = params[idx];
            if (idx == target.size()) {
                target.add(param);
            } else {
                target.set(idx, param);
            }
            paramIdxs.add(idx);
        } else if (el instanceof GridSqlSubquery) {
            DmlAstUtils.findParams((GridSqlSelect)((GridSqlSubquery)el).subquery(), params, target, paramIdxs);
        } else {
            for (int i = 0; i < el.size(); ++i) {
                DmlAstUtils.findParams((GridSqlElement)el.child(i), params, target, paramIdxs);
            }
        }
    }

    private static boolean findTablesInFrom(GridSqlElement from, IgnitePredicate<GridSqlElement> c) {
        if (from == null) {
            return false;
        }
        if (from instanceof GridSqlTable || from instanceof GridSqlSubquery) {
            return c.apply((Object)from);
        }
        if (from instanceof GridSqlJoin) {
            if (DmlAstUtils.findTablesInFrom((GridSqlElement)from.child(0), c)) {
                return true;
            }
            return DmlAstUtils.findTablesInFrom((GridSqlElement)from.child(1), c);
        }
        if (from instanceof GridSqlAlias) {
            return DmlAstUtils.findTablesInFrom((GridSqlElement)from.child(), c);
        }
        if (from instanceof GridSqlFunction) {
            return false;
        }
        throw new IllegalStateException(from.getClass().getName() + " : " + from.getSQL());
    }

    public static void collectAllGridTablesInTarget(GridSqlElement from, final Set<GridSqlTable> tbls) {
        DmlAstUtils.findTablesInFrom(from, new IgnitePredicate<GridSqlElement>(){

            public boolean apply(GridSqlElement el) {
                if (el instanceof GridSqlTable) {
                    tbls.add((GridSqlTable)el);
                }
                return false;
            }
        });
    }

    public static GridSqlTable gridTableForElement(GridSqlElement target) {
        HashSet<GridSqlTable> tbls = new HashSet<GridSqlTable>();
        DmlAstUtils.collectAllGridTablesInTarget(target, tbls);
        if (tbls.size() != 1) {
            throw new IgniteSQLException("Failed to determine target table", 3001);
        }
        return (GridSqlTable)tbls.iterator().next();
    }
}

