/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.logger.log4j2;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.logger.LoggerNodeIdAndApplicationAware;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.routing.RoutingAppender;
import org.apache.logging.log4j.core.config.AppenderControl;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilderFactory;
import org.apache.logging.log4j.core.config.builder.api.RootLoggerComponentBuilder;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.jetbrains.annotations.Nullable;

public class Log4J2Logger
implements IgniteLogger,
LoggerNodeIdAndApplicationAware {
    private static final String NODE_ID = "nodeId";
    private static final String APP_ID = "appId";
    private static final String CONSOLE_APPENDER = "autoConfiguredIgniteConsoleAppender";
    private static volatile boolean inited;
    private static volatile boolean quiet0;
    private static final Object mux;
    @GridToStringExclude
    private Logger impl;
    @GridToStringExclude
    private final String cfg;
    private final boolean quiet;
    @GridToStringExclude
    private volatile UUID nodeId;

    public Log4J2Logger() {
        this.addConsoleAppenderIfNeeded((IgniteClosure<Boolean, Logger>)(IgniteClosure & Serializable)init -> LogManager.getRootLogger());
        this.quiet = quiet0;
        this.cfg = null;
    }

    private Log4J2Logger(final Logger impl, String path) {
        assert (impl != null);
        this.addConsoleAppenderIfNeeded((IgniteClosure<Boolean, Logger>)new C1<Boolean, Logger>(){

            public Logger apply(Boolean init) {
                return impl;
            }
        });
        this.quiet = quiet0;
        this.cfg = path;
    }

    public Log4J2Logger(String path) throws IgniteCheckedException {
        if (path == null) {
            throw new IgniteCheckedException("Configuration XML file for Log4j2 must be specified.");
        }
        final URL cfgUrl = U.resolveIgniteUrl((String)path);
        if (cfgUrl == null) {
            throw new IgniteCheckedException("Log4j2 configuration path was not found: " + path);
        }
        this.addConsoleAppenderIfNeeded((IgniteClosure<Boolean, Logger>)new C1<Boolean, Logger>(){

            public Logger apply(Boolean init) {
                if (init.booleanValue()) {
                    Configurator.initialize((String)"root", (String)cfgUrl.toString());
                }
                return LogManager.getRootLogger();
            }
        });
        this.quiet = quiet0;
        this.cfg = path;
    }

    public Log4J2Logger(File cfgFile) throws IgniteCheckedException {
        if (cfgFile == null) {
            throw new IgniteCheckedException("Configuration XML file for Log4j must be specified.");
        }
        if (!cfgFile.exists() || cfgFile.isDirectory()) {
            throw new IgniteCheckedException("Log4j2 configuration path was not found or is a directory: " + cfgFile);
        }
        final String path = cfgFile.getAbsolutePath();
        this.addConsoleAppenderIfNeeded((IgniteClosure<Boolean, Logger>)new C1<Boolean, Logger>(){

            public Logger apply(Boolean init) {
                if (init.booleanValue()) {
                    Configurator.initialize((String)"root", (String)path);
                }
                return LogManager.getRootLogger();
            }
        });
        this.quiet = quiet0;
        this.cfg = cfgFile.getPath();
    }

    public Log4J2Logger(final URL cfgUrl) throws IgniteCheckedException {
        if (cfgUrl == null) {
            throw new IgniteCheckedException("Configuration XML file for Log4j must be specified.");
        }
        this.addConsoleAppenderIfNeeded((IgniteClosure<Boolean, Logger>)new C1<Boolean, Logger>(){

            public Logger apply(Boolean init) {
                if (init.booleanValue()) {
                    Configurator.initialize((String)"root", (String)cfgUrl.toString());
                }
                return LogManager.getRootLogger();
            }
        });
        this.quiet = quiet0;
        this.cfg = cfgUrl.getPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void cleanup() {
        Object object = mux;
        synchronized (object) {
            System.clearProperty(APP_ID);
            if (inited) {
                LogManager.shutdown();
            }
            inited = false;
        }
    }

    @Nullable
    public String fileName() {
        Configuration cfg = LoggerContext.getContext((boolean)false).getConfiguration();
        for (LoggerConfig logCfg = cfg.getLoggerConfig(this.impl.getName()); logCfg != null; logCfg = logCfg.getParent()) {
            for (Appender a : logCfg.getAppenders().values()) {
                if (a instanceof FileAppender) {
                    return ((FileAppender)a).getFileName();
                }
                if (a instanceof RollingFileAppender) {
                    return ((RollingFileAppender)a).getFileName();
                }
                if (!(a instanceof RoutingAppender)) continue;
                RoutingAppender routing = (RoutingAppender)a;
                Map appenders = routing.getAppenders();
                for (AppenderControl control : appenders.values()) {
                    Appender innerApp = control.getAppender();
                    if (innerApp instanceof FileAppender) {
                        return this.normalize(((FileAppender)innerApp).getFileName());
                    }
                    if (!(innerApp instanceof RollingFileAppender)) continue;
                    return this.normalize(((RollingFileAppender)innerApp).getFileName());
                }
            }
        }
        return null;
    }

    private String normalize(String path) {
        if (!U.isWindows()) {
            return path;
        }
        return path.replace('/', File.separatorChar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addConsoleAppenderIfNeeded(@Nullable IgniteClosure<Boolean, Logger> initLogClo) {
        if (inited) {
            this.impl = (Logger)initLogClo.apply((Object)false);
            return;
        }
        Object object = mux;
        synchronized (object) {
            if (inited) {
                this.impl = (Logger)initLogClo.apply((Object)false);
                return;
            }
            this.impl = (Logger)initLogClo.apply((Object)true);
            boolean quiet = Boolean.parseBoolean(System.getProperty("IGNITE_QUIET", "true"));
            boolean consoleAppenderFound = this.isConsoleAppenderConfigured();
            if (consoleAppenderFound && quiet) {
                quiet = false;
            }
            if (!consoleAppenderFound && !quiet && Boolean.parseBoolean(System.getProperty("IGNITE_CONSOLE_APPENDER", "true"))) {
                this.configureConsoleAppender();
            }
            quiet0 = quiet;
            inited = true;
        }
    }

    private boolean isConsoleAppenderConfigured() {
        Configuration cfg = LoggerContext.getContext((boolean)false).getConfiguration();
        if (cfg instanceof DefaultConfiguration) {
            return false;
        }
        for (LoggerConfig logCfg = cfg.getLoggerConfig(this.impl.getName()); logCfg != null; logCfg = logCfg.getParent()) {
            for (Appender appender : logCfg.getAppenders().values()) {
                if (!(appender instanceof ConsoleAppender) || ((ConsoleAppender)appender).getTarget() == ConsoleAppender.Target.SYSTEM_ERR) continue;
                return true;
            }
        }
        return false;
    }

    public Logger configureConsoleAppender() {
        LoggerContext ctx = LoggerContext.getContext((boolean)false);
        Configuration cfg = ctx.getConfiguration();
        if (cfg instanceof DefaultConfiguration) {
            ConfigurationBuilder cfgBuilder = ConfigurationBuilderFactory.newConfigurationBuilder();
            RootLoggerComponentBuilder rootLog = cfgBuilder.newRootLogger(Level.INFO);
            cfg = (Configuration)cfgBuilder.add(rootLog).build();
            this.addConsoleAppender(cfg);
            ctx.reconfigure(cfg);
        } else {
            this.addConsoleAppender(cfg);
            ctx.updateLoggers();
        }
        return ctx.getRootLogger();
    }

    private void addConsoleAppender(Configuration logCfg) {
        PatternLayout layout = PatternLayout.newBuilder().withPattern("%d{ISO8601}][%-5p][%t][%c{1}] %m%n").withCharset(Charset.defaultCharset()).withAlwaysWriteExceptions(false).withNoConsoleNoAnsi(false).build();
        ConsoleAppender consoleApp = ((ConsoleAppender.Builder)((ConsoleAppender.Builder)ConsoleAppender.newBuilder().setTarget(ConsoleAppender.Target.SYSTEM_OUT).setName(CONSOLE_APPENDER)).setLayout((Layout)layout)).build();
        consoleApp.start();
        logCfg.addAppender((Appender)consoleApp);
        logCfg.getRootLogger().addAppender((Appender)consoleApp, Level.TRACE, null);
    }

    public static boolean isConfigured() {
        return !(LoggerContext.getContext((boolean)false).getConfiguration() instanceof DefaultConfiguration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setApplicationAndNode(@Nullable String application, UUID nodeId) {
        A.notNull((Object)nodeId, (String)NODE_ID);
        this.nodeId = nodeId;
        System.setProperty(NODE_ID, U.id8((UUID)nodeId));
        System.setProperty(APP_ID, application != null ? application : System.getProperty(APP_ID, "ignite"));
        if (inited) {
            Object object = mux;
            synchronized (object) {
                inited = false;
            }
            this.addConsoleAppenderIfNeeded((IgniteClosure<Boolean, Logger>)new C1<Boolean, Logger>(){

                public Logger apply(Boolean init) {
                    if (init.booleanValue()) {
                        LoggerContext.getContext((boolean)false).reconfigure();
                    }
                    return LogManager.getRootLogger();
                }
            });
        }
    }

    public UUID getNodeId() {
        return this.nodeId;
    }

    public Log4J2Logger getLogger(Object ctgr) {
        if (ctgr == null) {
            return new Log4J2Logger(LogManager.getRootLogger(), this.cfg);
        }
        if (ctgr instanceof Class) {
            String name = ((Class)ctgr).getName();
            return new Log4J2Logger(LogManager.getLogger((String)name), this.cfg);
        }
        String name = ctgr.toString();
        return new Log4J2Logger(LogManager.getLogger((String)name), this.cfg);
    }

    public void trace(String msg) {
        this.trace(null, msg);
    }

    public void trace(@Nullable String marker, String msg) {
        if (!this.isTraceEnabled()) {
            this.warning("Logging at TRACE level without checking if TRACE level is enabled: " + msg);
        }
        this.impl.trace(this.getMarkerOrNull(marker), msg);
    }

    public void debug(String msg) {
        this.debug(null, msg);
    }

    public void debug(@Nullable String marker, String msg) {
        if (!this.isDebugEnabled()) {
            this.warning("Logging at DEBUG level without checking if DEBUG level is enabled: " + msg);
        }
        this.impl.debug(this.getMarkerOrNull(marker), msg);
    }

    public void info(String msg) {
        this.info(null, msg);
    }

    public void info(@Nullable String marker, String msg) {
        if (!this.isInfoEnabled()) {
            this.warning("Logging at INFO level without checking if INFO level is enabled: " + msg);
        }
        this.impl.info(this.getMarkerOrNull(marker), msg);
    }

    public void warning(String msg, @Nullable Throwable e) {
        this.warning(null, msg, e);
    }

    public void warning(@Nullable String marker, String msg, @Nullable Throwable e) {
        this.impl.warn(this.getMarkerOrNull(marker), msg, e);
    }

    public void error(String msg, @Nullable Throwable e) {
        this.error(null, msg, e);
    }

    public void error(@Nullable String marker, String msg, @Nullable Throwable e) {
        this.impl.error(this.getMarkerOrNull(marker), msg, e);
    }

    private Marker getMarkerOrNull(@Nullable String marker) {
        return marker != null ? MarkerManager.getMarker((String)marker) : null;
    }

    public boolean isTraceEnabled() {
        return this.impl.isTraceEnabled();
    }

    public boolean isDebugEnabled() {
        return this.impl.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.impl.isInfoEnabled();
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public String toString() {
        return S.toString(Log4J2Logger.class, (Object)this, (String)"config", (Object)this.cfg);
    }

    static {
        mux = new Object();
    }
}

