/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.springdata.repository.support;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.cache.Cache;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.springdata.repository.IgniteRepository;

public class IgniteRepositoryImpl<T, ID extends Serializable>
implements IgniteRepository<T, ID> {
    private final IgniteCache<ID, T> cache;

    public IgniteRepositoryImpl(IgniteCache<ID, T> cache) {
        this.cache = cache;
    }

    @Override
    public <S extends T> S save(ID key, S entity) {
        this.cache.put(key, entity);
        return entity;
    }

    @Override
    public <S extends T> Iterable<S> save(Map<ID, S> entities) {
        this.cache.putAll(entities);
        return entities.values();
    }

    public <S extends T> S save(S entity) {
        throw new UnsupportedOperationException("Use IgniteRepository.save(key,value) method instead.");
    }

    public <S extends T> Iterable<S> save(Iterable<S> entities) {
        throw new UnsupportedOperationException("Use IgniteRepository.save(Map<keys,value>) method instead.");
    }

    public T findOne(ID id) {
        return (T)this.cache.get(id);
    }

    public boolean exists(ID id) {
        return this.cache.containsKey(id);
    }

    public Iterable<T> findAll() {
        final Iterator iter = this.cache.iterator();
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){

                    @Override
                    public boolean hasNext() {
                        return iter.hasNext();
                    }

                    @Override
                    public T next() {
                        return ((Cache.Entry)iter.next()).getValue();
                    }

                    @Override
                    public void remove() {
                        iter.remove();
                    }
                };
            }
        };
    }

    private Set<ID> toSet(Iterable<ID> ids) {
        if (ids instanceof Set) {
            return (Set)ids;
        }
        Iterator<ID> itr = ids.iterator();
        if (!itr.hasNext()) {
            return Collections.emptySet();
        }
        Serializable key = (Serializable)itr.next();
        AbstractSet keys = key instanceof Comparable ? new TreeSet() : new HashSet();
        keys.add(key);
        while (itr.hasNext()) {
            key = (Serializable)itr.next();
            keys.add(key);
        }
        return keys;
    }

    public Iterable<T> findAll(Iterable<ID> ids) {
        return this.cache.getAll(this.toSet(ids)).values();
    }

    public long count() {
        return this.cache.size(new CachePeekMode[]{CachePeekMode.PRIMARY});
    }

    public void delete(ID id) {
        this.cache.remove(id);
    }

    public void delete(T entity) {
        throw new UnsupportedOperationException("Use IgniteRepository.delete(key) method instead.");
    }

    public void delete(Iterable<? extends T> entities) {
        throw new UnsupportedOperationException("Use IgniteRepository.deleteAll(keys) method instead.");
    }

    @Override
    public void deleteAll(Iterable<ID> ids) {
        this.cache.removeAll(this.toSet(ids));
    }

    public void deleteAll() {
        this.cache.clear();
    }
}

