/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.objectstore.jdo.applib.service.settings;

import java.util.List;
import org.apache.isis.applib.AbstractService;
import org.apache.isis.applib.annotation.ActionSemantics;
import org.apache.isis.applib.annotation.MemberOrder;
import org.apache.isis.applib.annotation.Named;
import org.apache.isis.applib.annotation.Optional;
import org.apache.isis.applib.query.Query;
import org.apache.isis.applib.query.QueryDefault;
import org.apache.isis.applib.services.settings.ApplicationSetting;
import org.apache.isis.applib.services.settings.ApplicationSettingsServiceRW;
import org.apache.isis.applib.services.settings.SettingAbstract;
import org.apache.isis.applib.services.settings.SettingType;
import org.apache.isis.objectstore.jdo.applib.service.settings.ApplicationSettingJdo;
import org.joda.time.LocalDate;

@Named(value="Application Settings")
public class ApplicationSettingsServiceJdo
extends AbstractService
implements ApplicationSettingsServiceRW {
    @ActionSemantics(value=ActionSemantics.Of.SAFE)
    public ApplicationSetting find(@Named(value="Key") String key) {
        return (ApplicationSetting)this.firstMatch((Query)new QueryDefault(ApplicationSettingJdo.class, "findByKey", new Object[]{"key", key}));
    }

    @ActionSemantics(value=ActionSemantics.Of.SAFE)
    @MemberOrder(sequence="1")
    public List<ApplicationSetting> listAll() {
        return this.allMatches((Query)new QueryDefault(ApplicationSettingJdo.class, "findAll", new Object[0]));
    }

    @MemberOrder(sequence="10")
    public ApplicationSetting newString(@Named(value="Key") String key, @Named(value="Description") @Optional String description, @Named(value="Value") String value) {
        return this.newSetting(key, description, SettingType.STRING, value);
    }

    @MemberOrder(sequence="11")
    public ApplicationSettingJdo newInt(@Named(value="Key") String key, @Named(value="Description") @Optional String description, @Named(value="Value") Integer value) {
        return this.newSetting(key, description, SettingType.INT, value.toString());
    }

    @MemberOrder(sequence="12")
    public ApplicationSettingJdo newLong(@Named(value="Key") String key, @Named(value="Description") @Optional String description, @Named(value="Value") Long value) {
        return this.newSetting(key, description, SettingType.LONG, value.toString());
    }

    @MemberOrder(sequence="13")
    public ApplicationSettingJdo newLocalDate(@Named(value="Key") String key, @Named(value="Description") @Optional String description, @Named(value="Value") LocalDate value) {
        return this.newSetting(key, description, SettingType.LOCAL_DATE, value.toString(SettingAbstract.DATE_FORMATTER));
    }

    @MemberOrder(sequence="14")
    public ApplicationSettingJdo newBoolean(@Named(value="Key") String key, @Named(value="Description") @Optional String description, @Named(value="Value") @Optional Boolean value) {
        return this.newSetting(key, description, SettingType.BOOLEAN, new Boolean(value != null && value != false).toString());
    }

    private ApplicationSettingJdo newSetting(String key, String description, SettingType settingType, String valueRaw) {
        ApplicationSettingJdo setting = (ApplicationSettingJdo)((Object)this.newTransientInstance(ApplicationSettingJdo.class));
        setting.setKey(key);
        setting.setDescription(description);
        setting.setValueRaw(valueRaw);
        setting.setType(settingType);
        this.persist((Object)setting);
        return setting;
    }
}

