/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.tool.mavenplugin;

import java.io.File;
import java.util.List;
import java.util.Set;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.config.IsisConfigurationBuilderDefault;
import org.apache.isis.core.metamodel.app.IsisMetaModel;
import org.apache.isis.core.metamodel.progmodel.ProgrammingModel;
import org.apache.isis.core.metamodel.runtimecontext.RuntimeContext;
import org.apache.isis.core.metamodel.runtimecontext.noruntime.RuntimeContextNoRuntime;
import org.apache.isis.core.runtime.services.ServicesInstallerFromAnnotation;
import org.apache.isis.core.runtime.services.ServicesInstallerFromConfigurationAndAnnotation;
import org.apache.isis.core.runtime.system.DeploymentType;
import org.apache.isis.progmodels.dflt.ProgrammingModelFacetsJava5;
import org.apache.isis.tool.mavenplugin.MetaModelProcessor;
import org.apache.isis.tool.mavenplugin.util.IsisMetaModels;
import org.apache.isis.tool.mavenplugin.util.MavenProjects;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class IsisMojoAbstract
extends AbstractMojo {
    protected static final String CURRENT_PLUGIN_KEY = "org.apache.isis.tool:isis-maven-plugin";
    @Component
    private MavenProject mavenProject;
    @Parameter(required=true, readonly=false, property="isisConfigDir")
    private String isisConfigDir;
    private final MetaModelProcessor metaModelProcessor;
    private final ContextForMojo context;

    protected IsisMojoAbstract(MetaModelProcessor metaModelProcessor) {
        this.metaModelProcessor = metaModelProcessor;
        this.context = new ContextForMojo(this.mavenProject, this.getLog());
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        List<Object> serviceList;
        Plugin plugin = MavenProjects.lookupPlugin(this.mavenProject, CURRENT_PLUGIN_KEY);
        List<Object> list = serviceList = plugin != null ? this.serviceListFor(plugin) : null;
        if (serviceList == null || serviceList.size() == 0) {
            return;
        }
        this.getLog().info((CharSequence)("Found " + serviceList.size() + " services"));
        this.usingIsisMetaModel(serviceList, this.metaModelProcessor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void usingIsisMetaModel(List<Object> serviceList, MetaModelProcessor metaModelProcessor) throws MojoExecutionException, MojoFailureException {
        IsisMetaModel isisMetaModel = null;
        try {
            isisMetaModel = IsisMojoAbstract.bootstrapIsis(serviceList);
            metaModelProcessor.process(isisMetaModel, this.context);
        }
        finally {
            IsisMetaModels.disposeSafely(isisMetaModel);
        }
    }

    private List<Object> serviceListFor(Plugin plugin) throws MojoFailureException {
        ServicesInstallerFromAnnotation servicesInstaller;
        IsisConfiguration isisConfiguration = this.getIsisConfiguration();
        if (isisConfiguration == null) {
            servicesInstaller = new ServicesInstallerFromAnnotation();
        } else {
            ServicesInstallerFromConfigurationAndAnnotation servicesInstallerFromConfigurationAndAnnotation = new ServicesInstallerFromConfigurationAndAnnotation();
            servicesInstallerFromConfigurationAndAnnotation.setConfiguration(isisConfiguration);
            servicesInstaller = servicesInstallerFromConfigurationAndAnnotation;
        }
        servicesInstaller.setIgnoreFailures(true);
        servicesInstaller.init();
        return servicesInstaller.getServices(DeploymentType.SERVER_PROTOTYPE);
    }

    private IsisConfiguration getIsisConfiguration() throws MojoFailureException {
        File file = this.getIsisConfigDir();
        String absoluteConfigDir = file.getAbsolutePath();
        if (!file.exists() || !file.isDirectory()) {
            this.context.throwFailureException("Configuration error", String.format("isisConfigDir (%s) does not exist or is not a directory", absoluteConfigDir));
        }
        IsisConfigurationBuilderDefault configBuilder = new IsisConfigurationBuilderDefault(absoluteConfigDir);
        configBuilder.addDefaultConfigurationResources();
        return configBuilder.getConfiguration();
    }

    private File getIsisConfigDir() {
        File file = new File(this.isisConfigDir);
        if (!file.isAbsolute()) {
            File basedir = this.mavenProject.getBasedir();
            file = new File(basedir, this.isisConfigDir);
        }
        return file;
    }

    private static IsisMetaModel bootstrapIsis(List<Object> serviceList) {
        IsisMetaModel isisMetaModel = new IsisMetaModel((RuntimeContext)new RuntimeContextNoRuntime(), (ProgrammingModel)new ProgrammingModelFacetsJava5(), serviceList);
        isisMetaModel.init();
        return isisMetaModel;
    }

    static class ContextForMojo
    implements MetaModelProcessor.Context {
        private final MavenProject mavenProject;
        private final Log log;

        public ContextForMojo(MavenProject mavenProject, Log log) {
            this.mavenProject = mavenProject;
            this.log = log;
        }

        @Override
        public MavenProject getMavenProject() {
            return this.mavenProject;
        }

        @Override
        public Log getLog() {
            return this.log;
        }

        @Override
        public void throwFailureException(String errorMessage, Set<String> logMessages) throws MojoFailureException {
            this.logErrors(logMessages);
            throw new MojoFailureException(errorMessage);
        }

        @Override
        public void throwFailureException(String errorMessage, String ... logMessages) throws MojoFailureException {
            this.logErrors(logMessages);
            throw new MojoFailureException(errorMessage);
        }

        @Override
        public void throwExecutionException(String errorMessage, Exception e) throws MojoExecutionException {
            this.logErrors(errorMessage);
            throw new MojoExecutionException(errorMessage, e);
        }

        private void logErrors(Set<String> logMessages) {
            this.logErrors(logMessages.toArray(new String[0]));
        }

        @Override
        public void logErrors(String ... logMessages) {
            this.log.error((CharSequence)"");
            this.log.error((CharSequence)"");
            this.log.error((CharSequence)"");
            for (String logMessage : logMessages) {
                this.log.error((CharSequence)logMessage);
            }
            this.log.error((CharSequence)"");
            this.log.error((CharSequence)"");
            this.log.error((CharSequence)"");
        }
    }
}

