/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.tool.mavenplugin;

import java.util.Collection;
import org.apache.isis.core.metamodel.app.IsisMetaModel;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.specloader.validator.ValidationFailures;
import org.apache.isis.tool.mavenplugin.IsisMojoAbstract;
import org.apache.isis.tool.mavenplugin.MetaModelProcessor;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="validate", defaultPhase=LifecyclePhase.TEST, requiresProject=true, requiresDependencyResolution=ResolutionScope.COMPILE, requiresDependencyCollection=ResolutionScope.COMPILE)
public class IsisMojoValidate
extends IsisMojoAbstract {
    protected IsisMojoValidate() {
        super(new ValidateMetaModelProcessor());
    }

    static class ValidateMetaModelProcessor
    implements MetaModelProcessor {
        ValidateMetaModelProcessor() {
        }

        @Override
        public void process(IsisMetaModel isisMetaModel, MetaModelProcessor.Context context) throws MojoFailureException, MojoExecutionException {
            Collection objectSpecifications = isisMetaModel.getSpecificationLoader().allSpecifications();
            for (ObjectSpecification objectSpecification : objectSpecifications) {
                context.getLog().debug((CharSequence)("loaded: " + objectSpecification.getFullIdentifier()));
            }
            ValidationFailures validationFailures = isisMetaModel.getValidationFailures();
            if (validationFailures.occurred()) {
                context.throwFailureException(validationFailures.getNumberOfMessages() + " problems found.", validationFailures.getMessages());
            }
        }
    }
}

