/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.applib.util;

import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;

public class PathNode {
    private static final Pattern NODE = Pattern.compile("^([^\\[]*)(\\[(.+)\\])?$");
    private static final Pattern WHITESPACE = Pattern.compile("\\s+");
    private static final Pattern KEY_VALUE = Pattern.compile("^([^=]+)=(.+)$");
    public static final PathNode NULL = new PathNode("", Collections.<String, String>emptyMap());
    private final String key;
    private final Map<String, String> criteria;

    public static PathNode parse(String path) {
        Matcher nodeMatcher = NODE.matcher(path);
        if (!nodeMatcher.matches()) {
            return null;
        }
        int groupCount = nodeMatcher.groupCount();
        if (groupCount < 1) {
            return null;
        }
        String key = nodeMatcher.group(1);
        HashMap criteria = Maps.newHashMap();
        String criteriaStr = nodeMatcher.group(3);
        if (criteriaStr != null) {
            for (String criterium : Splitter.on((Pattern)WHITESPACE).split((CharSequence)criteriaStr)) {
                Matcher keyValueMatcher = KEY_VALUE.matcher(criterium);
                if (!keyValueMatcher.matches()) continue;
                criteria.put(keyValueMatcher.group(1), keyValueMatcher.group(2));
            }
        }
        return new PathNode(key, criteria);
    }

    private PathNode(String key, Map<String, String> criteria) {
        this.key = key;
        this.criteria = Collections.unmodifiableMap(criteria);
    }

    public String getKey() {
        return this.key;
    }

    public Map<String, String> getCriteria() {
        return this.criteria;
    }

    public boolean hasCriteria() {
        return !this.getCriteria().isEmpty();
    }

    public boolean matches(JsonRepresentation repr) {
        if (!repr.isMap()) {
            return false;
        }
        for (Map.Entry<String, String> criterium : this.getCriteria().entrySet()) {
            String actualValue;
            String requiredValue = criterium.getValue();
            if (Objects.equal((Object)requiredValue, (Object)(actualValue = repr.getString(criterium.getKey())))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PathNode other = (PathNode)obj;
        return !(this.key == null ? other.key != null : !this.key.equals(other.key));
    }

    public String toString() {
        return this.key + (this.criteria.isEmpty() ? "" : this.criteria);
    }
}

