/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.applib;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import org.apache.isis.applib.util.Enums;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.domainobjects.ActionResultRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.domainobjects.DomainObjectRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.domainobjects.ListRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.domainobjects.ObjectActionRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.domainobjects.ObjectCollectionRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.domainobjects.ObjectPropertyRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.domaintypes.ActionDescriptionRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.domaintypes.ActionParameterDescriptionRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.domaintypes.CollectionDescriptionRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.domaintypes.DomainTypeRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.domaintypes.PropertyDescriptionRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.domaintypes.TypeActionResultRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.domaintypes.TypeListRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.errors.ErrorRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.homepage.HomePageRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.user.UserRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.util.Parser;
import org.apache.isis.viewer.restfulobjects.applib.version.VersionRepresentation;

public enum RepresentationType {
    HOME_PAGE("application/json;profile=urn:org.restfulobjects:repr-types/homepage", HomePageRepresentation.class),
    USER("application/json;profile=urn:org.restfulobjects:repr-types/user", UserRepresentation.class),
    VERSION("application/json;profile=urn:org.restfulobjects:repr-types/version", VersionRepresentation.class),
    LIST("application/json;profile=urn:org.restfulobjects:repr-types/list", ListRepresentation.class),
    DOMAIN_OBJECT("application/json;profile=urn:org.restfulobjects:repr-types/object", DomainObjectRepresentation.class),
    OBJECT_PROPERTY("application/json;profile=urn:org.restfulobjects:repr-types/object-property", ObjectPropertyRepresentation.class),
    OBJECT_COLLECTION("application/json;profile=urn:org.restfulobjects:repr-types/object-collection", ObjectCollectionRepresentation.class),
    OBJECT_ACTION("application/json;profile=urn:org.restfulobjects:repr-types/object-action", ObjectActionRepresentation.class),
    ACTION_RESULT("application/json;profile=urn:org.restfulobjects:repr-types/action-result", ActionResultRepresentation.class),
    TYPE_LIST("application/json;profile=urn:org.restfulobjects:repr-types/type-list", TypeListRepresentation.class),
    DOMAIN_TYPE("application/json;profile=urn:org.restfulobjects:repr-types/domain-type", DomainTypeRepresentation.class),
    PROPERTY_DESCRIPTION("application/json;profile=urn:org.restfulobjects:repr-types/property-description", PropertyDescriptionRepresentation.class),
    COLLECTION_DESCRIPTION("application/json;profile=urn:org.restfulobjects:repr-types/collection-description", CollectionDescriptionRepresentation.class),
    ACTION_DESCRIPTION("application/json;profile=urn:org.restfulobjects:repr-types/action-description", ActionDescriptionRepresentation.class),
    ACTION_PARAMETER_DESCRIPTION("application/json;profile=urn:org.restfulobjects:repr-types/action-param-description", ActionParameterDescriptionRepresentation.class),
    TYPE_ACTION_RESULT("application/json;profile=urn:org.restfulobjects:repr-types/type-action-result", TypeActionResultRepresentation.class),
    ERROR("application/json;profile=urn:org.restfulobjects:repr-types/error", ErrorRepresentation.class),
    GENERIC("application/json", JsonRepresentation.class);

    private final String name;
    private final MediaType mediaType;
    private final Class<? extends JsonRepresentation> representationClass;

    private RepresentationType(String mediaTypeStr, Class<? extends JsonRepresentation> representationClass) {
        this(MediaType.valueOf((String)mediaTypeStr), representationClass);
    }

    private RepresentationType(MediaType mediaType, Class<? extends JsonRepresentation> representationClass) {
        this.representationClass = representationClass;
        this.name = Enums.enumToCamelCase((Enum)this);
        this.mediaType = mediaType;
    }

    public String getName() {
        return this.name;
    }

    public final MediaType getMediaType() {
        return this.mediaType;
    }

    public MediaType getMediaType(String parameter, String paramValue) {
        return this.getMediaType(Collections.singletonMap(parameter, paramValue));
    }

    public MediaType getMediaType(Map<String, String> mediaTypeParams) {
        HashMap parameters = Maps.newHashMap((Map)this.mediaType.getParameters());
        parameters.putAll(mediaTypeParams);
        return new MediaType(this.mediaType.getType(), this.mediaType.getSubtype(), (Map)parameters);
    }

    public String getMediaTypeProfile() {
        return (String)this.getMediaType().getParameters().get("profile");
    }

    public Class<? extends JsonRepresentation> getRepresentationClass() {
        return this.representationClass;
    }

    public static RepresentationType lookup(String name) {
        for (RepresentationType representationType : RepresentationType.values()) {
            if (!representationType.getName().equals(name)) continue;
            return representationType;
        }
        return GENERIC;
    }

    public static RepresentationType lookup(MediaType mediaType) {
        if (mediaType != null) {
            for (RepresentationType representationType : RepresentationType.values()) {
                MediaType candidate = representationType.getMediaType();
                if (!candidate.getType().equals(mediaType.getType()) || !candidate.getSubtype().equals(mediaType.getSubtype())) continue;
                String candidateProfile = (String)candidate.getParameters().get("profile");
                String mediaTypeProfile = (String)mediaType.getParameters().get("profile");
                if (candidateProfile != null && !candidateProfile.equals(mediaTypeProfile)) continue;
                return representationType;
            }
        }
        return GENERIC;
    }

    public static Parser<RepresentationType> parser() {
        return new Parser<RepresentationType>(){

            @Override
            public RepresentationType valueOf(String str) {
                return RepresentationType.lookup(str);
            }

            @Override
            public String asString(RepresentationType t) {
                return t.getName();
            }
        };
    }
}

