/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.applib.client;

import java.net.URI;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.LinkRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.RestfulHttpMethod;
import org.apache.isis.viewer.restfulobjects.applib.client.ClientRequestConfigurer;
import org.apache.isis.viewer.restfulobjects.applib.client.RepresentationWalker;
import org.apache.isis.viewer.restfulobjects.applib.client.RestfulRequest;
import org.apache.isis.viewer.restfulobjects.applib.client.RestfulResponse;
import org.apache.isis.viewer.restfulobjects.applib.domainobjects.DomainObjectResource;
import org.apache.isis.viewer.restfulobjects.applib.domainobjects.DomainServiceResource;
import org.apache.isis.viewer.restfulobjects.applib.domaintypes.DomainTypeResource;
import org.apache.isis.viewer.restfulobjects.applib.homepage.HomePageResource;
import org.apache.isis.viewer.restfulobjects.applib.user.UserResource;
import org.apache.isis.viewer.restfulobjects.applib.version.VersionResource;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ClientRequestFactory;
import org.jboss.resteasy.client.core.executors.ApacheHttpClient4Executor;

public class RestfulClient {
    private final HomePageResource homePageResource;
    private final UserResource userResource;
    private final VersionResource versionResource;
    private final DomainObjectResource domainObjectResource;
    private final DomainServiceResource domainServiceResource;
    private final DomainTypeResource domainTypeResource;
    private final ClientExecutor executor;
    private final ClientRequestFactory clientRequestFactory;

    public RestfulClient(URI baseUri) {
        this(baseUri, (ClientExecutor)new ApacheHttpClient4Executor((HttpClient)new DefaultHttpClient()));
    }

    public RestfulClient(URI baseUri, ClientExecutor clientExecutor) {
        this.executor = clientExecutor;
        this.clientRequestFactory = new ClientRequestFactory(clientExecutor, baseUri);
        this.homePageResource = (HomePageResource)this.clientRequestFactory.createProxy(HomePageResource.class);
        this.userResource = (UserResource)this.clientRequestFactory.createProxy(UserResource.class);
        this.domainTypeResource = (DomainTypeResource)this.clientRequestFactory.createProxy(DomainTypeResource.class);
        this.domainServiceResource = (DomainServiceResource)this.clientRequestFactory.createProxy(DomainServiceResource.class);
        this.domainObjectResource = (DomainObjectResource)this.clientRequestFactory.createProxy(DomainObjectResource.class);
        this.versionResource = (VersionResource)this.clientRequestFactory.createProxy(VersionResource.class);
    }

    public HomePageResource getHomePageResource() {
        return this.homePageResource;
    }

    public UserResource getUserResource() {
        return this.userResource;
    }

    public VersionResource getVersionResource() {
        return this.versionResource;
    }

    public DomainTypeResource getDomainTypeResource() {
        return this.domainTypeResource;
    }

    public DomainObjectResource getDomainObjectResource() {
        return this.domainObjectResource;
    }

    public DomainServiceResource getDomainServiceResource() {
        return this.domainServiceResource;
    }

    public RepresentationWalker createWalker(Response response) {
        return new RepresentationWalker(this, response);
    }

    public RestfulResponse<JsonRepresentation> follow(LinkRepresentation link) throws Exception {
        return this.followT(link);
    }

    public <T extends JsonRepresentation> RestfulResponse<T> followT(LinkRepresentation link) throws Exception {
        return this.followT(link, JsonRepresentation.newMap(new String[0]));
    }

    public RestfulResponse<JsonRepresentation> follow(LinkRepresentation link, JsonRepresentation requestArgs) throws Exception {
        return this.followT(link, requestArgs);
    }

    public <T extends JsonRepresentation> RestfulResponse<T> followT(LinkRepresentation link, JsonRepresentation requestArgs) throws Exception {
        return link.follow(this.executor, requestArgs);
    }

    public RestfulRequest createRequest(RestfulHttpMethod httpMethod, String uriTemplate) {
        boolean includesScheme = uriTemplate.startsWith("http:") || uriTemplate.startsWith("https:");
        String base = this.clientRequestFactory.getBase().toString();
        String uri = (includesScheme ? "" : base) + uriTemplate;
        ClientRequestConfigurer clientRequestConfigurer = ClientRequestConfigurer.create(this.executor, uri);
        clientRequestConfigurer.accept(MediaType.APPLICATION_JSON_TYPE);
        clientRequestConfigurer.setHttpMethod(httpMethod);
        return new RestfulRequest(clientRequestConfigurer);
    }

    public ClientRequestFactory getClientRequestFactory() {
        return this.clientRequestFactory;
    }
}

