/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.applib;

import org.apache.isis.viewer.restfulobjects.applib.RelDefinition;

public enum Rel {
    SELF(RelDefinition.IANA, "self"),
    DESCRIBEDBY(RelDefinition.IANA, "describedby"),
    UP(RelDefinition.IANA, "up"),
    PREVIOUS(RelDefinition.IANA, "previous"),
    NEXT(RelDefinition.IANA, "next"),
    HELP(RelDefinition.IANA, "help"),
    ICON(RelDefinition.IANA, "icon"),
    ACTION(RelDefinition.RO_SPEC, "action"),
    ACTION_PARAM(RelDefinition.RO_SPEC, "action-param"),
    ADD_TO(RelDefinition.RO_SPEC, "add-to"),
    ATTACHMENT(RelDefinition.RO_SPEC, "attachment"),
    CHOICE(RelDefinition.RO_SPEC, "choice"),
    CLEAR(RelDefinition.RO_SPEC, "clear"),
    COLLECTION(RelDefinition.RO_SPEC, "collection"),
    DEFAULT(RelDefinition.RO_SPEC, "default"),
    DELETE(RelDefinition.RO_SPEC, "delete"),
    DETAILS(RelDefinition.RO_SPEC, "details"),
    DOMAIN_TYPE(RelDefinition.RO_SPEC, "domain-type"),
    DOMAIN_TYPES(RelDefinition.RO_SPEC, "domain-types"),
    ELEMENT(RelDefinition.RO_SPEC, "element"),
    ELEMENT_TYPE(RelDefinition.RO_SPEC, "element-type"),
    INVOKE(RelDefinition.RO_SPEC, "invoke"),
    MODIFY(RelDefinition.RO_SPEC, "modify"),
    PERSIST(RelDefinition.RO_SPEC, "persist"),
    PROPERTY(RelDefinition.RO_SPEC, "property"),
    REMOVE_FROM(RelDefinition.RO_SPEC, "remove-from"),
    RETURN_TYPE(RelDefinition.RO_SPEC, "return-type"),
    SERVICE(RelDefinition.RO_SPEC, "service"),
    SERVICES(RelDefinition.RO_SPEC, "services"),
    UPDATE(RelDefinition.RO_SPEC, "update"),
    USER(RelDefinition.RO_SPEC, "user"),
    VALUE(RelDefinition.RO_SPEC, "value"),
    VERSION(RelDefinition.RO_SPEC, "version"),
    CONTRIBUTED_BY(RelDefinition.IMPL, "contributed-by");

    private final RelDefinition relDef;
    private final String relSuffix;

    private Rel(RelDefinition relDef, String name) {
        this.relDef = relDef;
        this.relSuffix = name;
    }

    public String getName() {
        return this.relDef.nameOf(this.relSuffix);
    }

    public String andParam(String paramName, String paramValue) {
        return this.getName() + (this.relDef.canAddParams() ? ";" + paramName + "=" + "\"" + paramValue + "\"" : "");
    }

    public boolean matches(Rel otherRel) {
        return this == otherRel;
    }

    public boolean matches(String otherRelStr) {
        Rel otherRel = Rel.parse(otherRelStr);
        return this.matches(otherRel);
    }

    public static Rel parse(String str) {
        int i = str.indexOf(";");
        if (i != -1) {
            str = str.substring(0, i);
        }
        for (Rel candidate : Rel.values()) {
            if (!candidate.getName().equals(str)) continue;
            return candidate;
        }
        return null;
    }
}

