/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.applib.domainobjects;

import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.domainobjects.AbstractObjectMemberRepresentation;
import org.codehaus.jackson.JsonNode;

public class ActionResultRepresentation
extends AbstractObjectMemberRepresentation {
    public ActionResultRepresentation(JsonNode jsonNode) {
        super(jsonNode);
    }

    public JsonRepresentation getResult() {
        return this.getRepresentation("result", new Object[0]);
    }

    public ResultType getResultType() {
        String resultType = this.getString("resulttype");
        return ResultType.lookup(resultType);
    }

    public static enum ResultType {
        DOMAIN_OBJECT("domainobject"),
        LIST("list"),
        SCALAR_VALUE("scalarvalue"),
        VOID("void");

        private final String value;

        private ResultType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static ResultType lookup(String value) {
            for (ResultType resultType : ResultType.values()) {
                if (!resultType.value.equals(value)) continue;
                return resultType;
            }
            throw new IllegalArgumentException("Value '" + value + "' is not a valid result type");
        }

        public boolean isVoid() {
            return this == VOID;
        }
    }
}

