/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.applib.domainobjects;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Map;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.LinkRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.Rel;
import org.apache.isis.viewer.restfulobjects.applib.domainobjects.DomainObjectMemberRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.domainobjects.DomainRepresentation;
import org.codehaus.jackson.JsonNode;

public class DomainObjectRepresentation
extends DomainRepresentation {
    public DomainObjectRepresentation(JsonNode jsonNode) {
        super(jsonNode);
    }

    public String getTitle() {
        return this.getString("title");
    }

    public String getDomainType() {
        return this.getString("domainType");
    }

    public String getInstanceId() {
        return this.getString("instanceId");
    }

    public String getServiceId() {
        return this.getString("serviceId");
    }

    public JsonRepresentation getMembers() {
        return this.getRepresentation("members", new Object[0]);
    }

    public DomainObjectMemberRepresentation getProperty(String id) {
        return this.getMember(id, "property");
    }

    public JsonRepresentation getProperties() {
        return this.getMembersOfType("property");
    }

    public DomainObjectMemberRepresentation getCollection(String id) {
        return this.getMember(id, "collection");
    }

    public JsonRepresentation getCollections() {
        return this.getMembersOfType("collection");
    }

    public DomainObjectMemberRepresentation getAction(String id) {
        return this.getMember(id, "action");
    }

    public JsonRepresentation getActions() {
        return this.getMembersOfType("action");
    }

    public LinkRepresentation getPersistLink() {
        return this.getLinkWithRel(Rel.PERSIST);
    }

    public String getOid() {
        return this.getString("extensions.oid");
    }

    private DomainObjectMemberRepresentation getMember(String id, String memberType) {
        JsonRepresentation jsonRepr = this.getRepresentation("members.%s", id);
        if (jsonRepr == null) {
            return null;
        }
        DomainObjectMemberRepresentation member = jsonRepr.as(DomainObjectMemberRepresentation.class);
        return member.getMemberType().equals(memberType) ? member : null;
    }

    private JsonRepresentation getMembersOfType(String memberTypeOf) {
        JsonRepresentation members = this.getRepresentation("members", new Object[0]);
        return JsonRepresentation.newMap(new String[0]).mapPut(Iterables.filter(members.mapIterable(), DomainObjectRepresentation.havingMemberTypeOf(memberTypeOf)));
    }

    private static Predicate<Map.Entry<String, JsonRepresentation>> havingMemberTypeOf(final String memberTypeOf) {
        return new Predicate<Map.Entry<String, JsonRepresentation>>(){

            public boolean apply(Map.Entry<String, JsonRepresentation> input) {
                JsonRepresentation value = input.getValue();
                String memberType = value.getRepresentation("memberType", new Object[0]).asString();
                return memberTypeOf.equals(memberType);
            }
        };
    }
}

