/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.applib.util;

import com.google.common.base.Charsets;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.JsonNodeFactory;
import org.codehaus.jackson.node.ObjectNode;

public class JsonNodeUtils {
    private JsonNodeUtils() {
    }

    public static InputStream asInputStream(JsonNode jsonNode) {
        String jsonStr = jsonNode.toString();
        byte[] bytes = jsonStr.getBytes(Charsets.UTF_8);
        return new ByteArrayInputStream(bytes);
    }

    public static InputStream asInputStream(JsonRepresentation jsonRepresentation) {
        String jsonStr = jsonRepresentation.toString();
        byte[] bytes = jsonStr.getBytes(Charsets.UTF_8);
        return new ByteArrayInputStream(bytes);
    }

    public static ObjectNode walkNodeUpTo(ObjectNode node, List<String> keys) {
        for (String key : keys) {
            JsonNode jsonNode = node.get(key);
            if (jsonNode == null) {
                jsonNode = new ObjectNode(JsonNodeFactory.instance);
                node.put(key, jsonNode);
            } else if (!jsonNode.isObject()) {
                throw new IllegalArgumentException(String.format("walking path: '%s', existing key '%s' is not a map", keys, key));
            }
            node = (ObjectNode)jsonNode;
        }
        return node;
    }
}

