/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.applib.util;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.List;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.codehaus.jackson.JsonNode;

public final class UrlEncodingUtils {
    public static final Function<String, String> FUNCTION = new Function<String, String>(){

        public String apply(String input) {
            try {
                return URLDecoder.decode(input, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                return "";
            }
        }
    };

    private UrlEncodingUtils() {
    }

    public static String urlDecode(String string) {
        return (String)FUNCTION.apply((Object)string);
    }

    public static List<String> urlDecode(List<String> values) {
        return Lists.transform(values, FUNCTION);
    }

    public static String[] urlDecode(String[] values) {
        List<String> asList = Arrays.asList(values);
        return UrlEncodingUtils.urlDecode(asList).toArray(new String[0]);
    }

    public static String urlEncode(JsonNode jsonNode) {
        return UrlEncodingUtils.urlEncode(jsonNode.toString());
    }

    public static String urlEncode(JsonRepresentation jsonRepresentation) {
        return UrlEncodingUtils.urlEncode(jsonRepresentation.toString());
    }

    public static String urlEncode(String str) {
        try {
            return URLEncoder.encode(str, Charsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

