/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.domainobjects;

import java.util.Collection;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.Rel;
import org.apache.isis.viewer.restfulobjects.applib.RepresentationType;
import org.apache.isis.viewer.restfulobjects.rendering.LinkFollowSpecs;
import org.apache.isis.viewer.restfulobjects.rendering.RendererContext;
import org.apache.isis.viewer.restfulobjects.rendering.ReprRendererAbstract;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.DomainObjectLinkTo;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.DomainObjectReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAdapterLinkTo;

public class ListReprRenderer
extends ReprRendererAbstract<ListReprRenderer, Collection<ObjectAdapter>> {
    private ObjectAdapterLinkTo linkTo;
    private Collection<ObjectAdapter> objectAdapters;
    private ObjectSpecification elementType;
    private ObjectSpecification returnType;
    private Rel elementRel;

    public ListReprRenderer(RendererContext resourceContext, LinkFollowSpecs linkFollower, JsonRepresentation representation) {
        super(resourceContext, linkFollower, RepresentationType.LIST, representation);
        this.usingLinkToBuilder(new DomainObjectLinkTo());
    }

    public ListReprRenderer usingLinkToBuilder(ObjectAdapterLinkTo objectAdapterLinkToBuilder) {
        this.linkTo = objectAdapterLinkToBuilder.usingUrlBase(this.rendererContext);
        return this;
    }

    @Override
    public ListReprRenderer with(Collection<ObjectAdapter> objectAdapters) {
        this.objectAdapters = objectAdapters;
        return this;
    }

    public ListReprRenderer withElementRel(Rel elementRel) {
        this.elementRel = elementRel;
        return this;
    }

    public ListReprRenderer withReturnType(ObjectSpecification returnType) {
        this.returnType = returnType;
        return this;
    }

    public ListReprRenderer withElementType(ObjectSpecification elementType) {
        this.elementType = elementType;
        return this;
    }

    @Override
    public JsonRepresentation render() {
        this.addValue();
        this.addLinkToReturnType();
        this.addLinkToElementType();
        this.getExtensions();
        return this.representation;
    }

    private void addValue() {
        if (this.objectAdapters == null) {
            return;
        }
        JsonRepresentation values = JsonRepresentation.newArray();
        for (ObjectAdapter adapter : this.objectAdapters) {
            ObjectSpecification specification = adapter.getSpecification();
            if (specification.isHidden()) continue;
            JsonRepresentation linkToObject = this.linkTo.with(adapter).builder(this.elementRel).build();
            values.arrayAdd(linkToObject);
            LinkFollowSpecs linkFollower = this.getLinkFollowSpecs().follow("value", new Object[0]);
            if (!linkFollower.matches(linkToObject)) continue;
            DomainObjectReprRenderer renderer = new DomainObjectReprRenderer(this.getRendererContext(), linkFollower, JsonRepresentation.newMap((String[])new String[0]));
            JsonRepresentation domainObject = renderer.with(adapter).render();
            linkToObject.mapPut("value", domainObject);
        }
        this.representation.mapPut("value", values);
    }

    protected void addLinkToReturnType() {
        this.addLink(Rel.RETURN_TYPE, this.returnType);
    }

    protected void addLinkToElementType() {
        this.addLink(Rel.ELEMENT_TYPE, this.elementType);
    }
}

