/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.domainobjects;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.Rel;
import org.apache.isis.viewer.restfulobjects.applib.RepresentationType;
import org.apache.isis.viewer.restfulobjects.rendering.LinkFollowSpecs;
import org.apache.isis.viewer.restfulobjects.rendering.RendererContext;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.AbstractObjectMemberReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.DomainObjectReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.MutatorSpec;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAndProperty;
import org.apache.isis.viewer.restfulobjects.rendering.domaintypes.PropertyDescriptionReprRenderer;

public class ObjectPropertyReprRenderer
extends AbstractObjectMemberReprRenderer<ObjectPropertyReprRenderer, OneToOneAssociation> {
    public ObjectPropertyReprRenderer(RendererContext resourceContext, LinkFollowSpecs linkFollower, String propertyId, JsonRepresentation representation) {
        super(resourceContext, linkFollower, propertyId, RepresentationType.OBJECT_PROPERTY, representation, Where.OBJECT_FORMS);
    }

    @Override
    public JsonRepresentation render() {
        this.renderMemberContent();
        this.addValue();
        this.putDisabledReasonIfDisabled();
        if (this.mode.isStandalone() || this.mode.isMutated()) {
            this.addChoices();
            this.addExtensionsIsisProprietaryChangedObjects();
        }
        return this.representation;
    }

    private void addValue() {
        ObjectAdapter valueAdapter = ((OneToOneAssociation)this.objectMember).get(this.objectAdapter);
        ObjectSpecification specification = valueAdapter != null ? valueAdapter.getSpecification() : ((OneToOneAssociation)this.objectMember).getSpecification();
        DomainObjectReprRenderer.appendValueAndFormatOrRef(this.rendererContext, valueAdapter, specification, this.representation);
    }

    @Override
    protected void followDetailsLink(JsonRepresentation detailsLink) {
        ObjectPropertyReprRenderer renderer = new ObjectPropertyReprRenderer(this.getRendererContext(), this.getLinkFollowSpecs(), null, JsonRepresentation.newMap((String[])new String[0]));
        ((ObjectPropertyReprRenderer)renderer.with(new ObjectAndProperty(this.objectAdapter, (OneToOneAssociation)this.objectMember))).asFollowed();
        detailsLink.mapPut("value", renderer.render());
    }

    @Override
    protected void addMutatorsIfEnabled() {
        if (this.usability().isVetoed()) {
            return;
        }
        Map<String, MutatorSpec> mutators = this.memberType.getMutators();
        for (String mutator : mutators.keySet()) {
            MutatorSpec mutatorSpec = mutators.get(mutator);
            this.addLinkFor(mutatorSpec);
        }
    }

    private ObjectPropertyReprRenderer addChoices() {
        Object propertyChoices = this.propertyChoices();
        if (propertyChoices != null) {
            this.representation.mapPut("choices", propertyChoices);
        }
        return this;
    }

    private Object propertyChoices() {
        ObjectAdapter[] choiceAdapters = ((OneToOneAssociation)this.objectMember).getChoices(this.objectAdapter);
        if (choiceAdapters == null || choiceAdapters.length == 0) {
            return null;
        }
        ArrayList list = Lists.newArrayList();
        for (ObjectAdapter choiceAdapter : choiceAdapters) {
            ObjectSpecification choiceSpec = this.objectAdapter.getSpecification();
            list.add(DomainObjectReprRenderer.valueOrRef(this.rendererContext, choiceAdapter, choiceSpec));
        }
        return list;
    }

    @Override
    protected void addLinksToFormalDomainModel() {
        this.getLinks().arrayAdd(PropertyDescriptionReprRenderer.newLinkToBuilder(this.getRendererContext(), Rel.DESCRIBEDBY, this.objectAdapter.getSpecification(), (OneToOneAssociation)this.objectMember).build());
    }

    @Override
    protected void addLinksIsisProprietary() {
    }

    @Override
    protected void putExtensionsIsisProprietary() {
    }
}

