/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.domainobjects;

import java.util.Collection;
import java.util.Map;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionFacet;
import org.apache.isis.core.metamodel.facets.object.encodeable.EncodableFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectMember;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.Rel;
import org.apache.isis.viewer.restfulobjects.applib.RepresentationType;
import org.apache.isis.viewer.restfulobjects.applib.domainobjects.ActionResultRepresentation;
import org.apache.isis.viewer.restfulobjects.rendering.LinkBuilder;
import org.apache.isis.viewer.restfulobjects.rendering.LinkFollowSpecs;
import org.apache.isis.viewer.restfulobjects.rendering.RendererContext;
import org.apache.isis.viewer.restfulobjects.rendering.ReprRendererAbstract;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.DomainObjectLinkTo;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.DomainObjectReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.InvokeKeys;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ListReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.MemberType;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.MutatorSpec;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAdapterLinkTo;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAndActionInvocation;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ScalarValueReprRenderer;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.NullNode;

public class ActionResultReprRenderer
extends ReprRendererAbstract<ActionResultReprRenderer, ObjectAndActionInvocation> {
    private ObjectAdapterLinkTo adapterLinkTo = new DomainObjectLinkTo();
    private ObjectAdapter objectAdapter;
    private ObjectAction action;
    private JsonRepresentation arguments;
    private ObjectAdapter returnedAdapter;
    private final SelfLink selfLink;

    public ActionResultReprRenderer(RendererContext rendererContext, LinkFollowSpecs linkFollower, SelfLink selfLink, JsonRepresentation representation) {
        super(rendererContext, linkFollower, RepresentationType.ACTION_RESULT, representation);
        this.selfLink = selfLink;
    }

    @Override
    public ActionResultReprRenderer with(ObjectAndActionInvocation objectAndActionInvocation) {
        this.objectAdapter = objectAndActionInvocation.getObjectAdapter();
        this.action = objectAndActionInvocation.getAction();
        this.arguments = objectAndActionInvocation.getArguments();
        this.returnedAdapter = objectAndActionInvocation.getReturnedAdapter();
        this.adapterLinkTo.with(this.returnedAdapter);
        return this;
    }

    public void using(ObjectAdapterLinkTo adapterLinkTo) {
        this.adapterLinkTo = adapterLinkTo.with(this.objectAdapter);
    }

    @Override
    public JsonRepresentation render() {
        this.representationWithSelfFor(this.action, this.arguments);
        this.addResult(this.representation);
        this.addExtensionsIsisProprietaryChangedObjects();
        return this.representation;
    }

    private void addResult(JsonRepresentation representation) {
        JsonRepresentation result = JsonRepresentation.newMap((String[])new String[0]);
        ActionResultRepresentation.ResultType resultType = this.addResultTo(result);
        if (!resultType.isVoid()) {
            this.putResultType(representation, resultType);
            if (this.returnedAdapter != null) {
                representation.mapPut("result", result);
            } else {
                representation.mapPut("result", (JsonNode)NullNode.getInstance());
            }
        }
    }

    private ActionResultRepresentation.ResultType addResultTo(JsonRepresentation result) {
        ObjectSpecification returnType = this.action.getReturnType();
        if (returnType.getCorrespondingClass() == Void.TYPE) {
            return ActionResultRepresentation.ResultType.VOID;
        }
        CollectionFacet collectionFacet = (CollectionFacet)returnType.getFacet(CollectionFacet.class);
        if (collectionFacet != null) {
            if (this.returnedAdapter != null) {
                Collection collectionAdapters = collectionFacet.collection(this.returnedAdapter);
                ListReprRenderer renderer = new ListReprRenderer(this.rendererContext, null, result).withElementRel(Rel.ELEMENT);
                renderer.with(collectionAdapters).withReturnType(this.action.getReturnType()).withElementType(this.returnedAdapter.getElementSpecification());
                renderer.render();
            }
            return ActionResultRepresentation.ResultType.LIST;
        }
        EncodableFacet encodableFacet = (EncodableFacet)returnType.getFacet(EncodableFacet.class);
        if (encodableFacet != null) {
            if (this.returnedAdapter != null) {
                ScalarValueReprRenderer renderer = new ScalarValueReprRenderer(this.rendererContext, null, result);
                renderer.with(this.returnedAdapter).withReturnType(this.action.getReturnType());
                renderer.render();
            }
            return ActionResultRepresentation.ResultType.SCALAR_VALUE;
        }
        if (this.returnedAdapter != null) {
            DomainObjectReprRenderer renderer = new DomainObjectReprRenderer(this.rendererContext, null, result);
            renderer.with(this.returnedAdapter).includesSelf();
            renderer.render();
        }
        return ActionResultRepresentation.ResultType.DOMAIN_OBJECT;
    }

    private void putResultType(JsonRepresentation representation, ActionResultRepresentation.ResultType resultType) {
        representation.mapPut("resulttype", resultType.getValue());
    }

    private void representationWithSelfFor(ObjectAction action, JsonRepresentation bodyArgs) {
        JsonRepresentation links = JsonRepresentation.newArray();
        this.representation.mapPut("links", links);
        if (this.selfLink == SelfLink.EXCLUDED) {
            return;
        }
        LinkBuilder selfLinkBuilder = this.adapterLinkTo.memberBuilder(Rel.SELF, MemberType.ACTION, (ObjectMember)action, RepresentationType.ACTION_RESULT, "invoke");
        MemberType memberType = MemberType.of((ObjectMember)action);
        Map<String, MutatorSpec> mutators = memberType.getMutators();
        String mutator = InvokeKeys.getKeyFor(action.getSemantics());
        MutatorSpec mutatorSpec = mutators.get(mutator);
        selfLinkBuilder.withHttpMethod(mutatorSpec.httpMethod);
        JsonRepresentation selfLink = selfLinkBuilder.build();
        links.arrayAdd(selfLink);
        selfLink.mapPut("args", bodyArgs);
    }

    public static enum SelfLink {
        INCLUDED,
        EXCLUDED;

    }
}

