/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.domainobjects;

import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.oid.OidMarshaller;
import org.apache.isis.core.metamodel.spec.feature.ObjectMember;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.viewer.restfulobjects.applib.Rel;
import org.apache.isis.viewer.restfulobjects.applib.RepresentationType;
import org.apache.isis.viewer.restfulobjects.rendering.LinkBuilder;
import org.apache.isis.viewer.restfulobjects.rendering.RendererContext;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.MemberType;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAdapterLinkTo;
import org.apache.isis.viewer.restfulobjects.rendering.util.OidUtils;

public class DomainObjectLinkTo
implements ObjectAdapterLinkTo {
    protected RendererContext rendererContext;
    protected ObjectAdapter objectAdapter;

    @Override
    public final DomainObjectLinkTo usingUrlBase(RendererContext resourceContext) {
        this.rendererContext = resourceContext;
        return this;
    }

    @Override
    public ObjectAdapterLinkTo with(ObjectAdapter objectAdapter) {
        this.objectAdapter = objectAdapter;
        return this;
    }

    @Override
    public LinkBuilder builder() {
        return this.builder(null);
    }

    @Override
    public LinkBuilder builder(Rel rel) {
        LinkBuilder linkBuilder = LinkBuilder.newBuilder(this.rendererContext, this.relElseDefault(rel).getName(), RepresentationType.DOMAIN_OBJECT, this.linkRef(new StringBuilder()).toString(), new Object[0]);
        linkBuilder.withTitle(this.objectAdapter.titleString());
        return linkBuilder;
    }

    protected StringBuilder linkRef(StringBuilder buf) {
        String domainType = OidUtils.getDomainType(this.objectAdapter);
        String instanceId = OidUtils.getInstanceId(this.rendererContext, this.objectAdapter);
        return buf.append("objects/").append(domainType).append("/").append(instanceId);
    }

    protected Rel relElseDefault(Rel rel) {
        return rel != null ? rel : this.defaultRel();
    }

    protected Rel defaultRel() {
        return Rel.VALUE;
    }

    @Override
    public final LinkBuilder memberBuilder(Rel rel, MemberType memberType, ObjectMember objectMember, String ... parts) {
        return this.memberBuilder(rel, memberType, objectMember, memberType.getRepresentationType(), parts);
    }

    @Override
    public final LinkBuilder memberBuilder(Rel rel, MemberType memberType, ObjectMember objectMember, RepresentationType representationType, String ... parts) {
        StringBuilder buf = this.linkRef(new StringBuilder());
        buf.append("/").append(memberType.getUrlPart()).append(objectMember.getId());
        for (String part : parts) {
            if (part == null) continue;
            buf.append("/").append(part);
        }
        String url = buf.toString();
        return LinkBuilder.newBuilder(this.rendererContext, rel.getName(), representationType, url, new Object[0]);
    }

    protected static OidMarshaller getOidMarshaller() {
        return IsisContext.getOidMarshaller();
    }
}

