/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.domainobjects;

import javax.ws.rs.core.MediaType;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facets.object.encodeable.EncodableFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.Rel;
import org.apache.isis.viewer.restfulobjects.rendering.LinkFollowSpecs;
import org.apache.isis.viewer.restfulobjects.rendering.RendererContext;
import org.apache.isis.viewer.restfulobjects.rendering.ReprRendererAbstract;
import org.apache.isis.viewer.restfulobjects.rendering.ReprRendererException;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.JsonValueEncoder;

public class ScalarValueReprRenderer
extends ReprRendererAbstract<ScalarValueReprRenderer, ObjectAdapter> {
    private ObjectSpecification returnType;

    ScalarValueReprRenderer(RendererContext resourceContext, LinkFollowSpecs linkFollower, JsonRepresentation representation) {
        super(resourceContext, linkFollower, null, representation);
    }

    @Override
    public MediaType getMediaType() {
        throw new UnsupportedOperationException("no mediaType defined for scalar values");
    }

    @Override
    public ScalarValueReprRenderer with(ObjectAdapter objectAdapter) {
        EncodableFacet facet = (EncodableFacet)objectAdapter.getSpecification().getFacet(EncodableFacet.class);
        if (facet == null) {
            throw ReprRendererException.create("Not an (encodable) value", objectAdapter.titleString());
        }
        Object value = JsonValueEncoder.asObject(objectAdapter);
        this.representation.mapPut("value", value);
        return this;
    }

    @Override
    public JsonRepresentation render() {
        this.addLinkToReturnType();
        this.getExtensions();
        return this.representation;
    }

    public ScalarValueReprRenderer withReturnType(ObjectSpecification returnType) {
        this.returnType = returnType;
        return this;
    }

    private void addLinkToReturnType() {
        this.addLink(Rel.RETURN_TYPE, this.returnType);
    }
}

