/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.domaintypes;

import com.google.common.base.Strings;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.ObjectFeature;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.RepresentationType;
import org.apache.isis.viewer.restfulobjects.rendering.LinkFollowSpecs;
import org.apache.isis.viewer.restfulobjects.rendering.RendererContext;
import org.apache.isis.viewer.restfulobjects.rendering.ReprRendererAbstract;
import org.apache.isis.viewer.restfulobjects.rendering.domaintypes.ParentSpecAndFeature;

public abstract class AbstractTypeFeatureReprRenderer<R extends ReprRendererAbstract<R, ParentSpecAndFeature<T>>, T extends ObjectFeature>
extends ReprRendererAbstract<R, ParentSpecAndFeature<T>> {
    protected ObjectSpecification objectSpecification;
    protected T objectFeature;

    public AbstractTypeFeatureReprRenderer(RendererContext resourceContext, LinkFollowSpecs linkFollower, RepresentationType representationType, JsonRepresentation representation) {
        super(resourceContext, linkFollower, representationType, representation);
    }

    public ObjectSpecification getParentSpecification() {
        return this.objectSpecification;
    }

    public T getObjectFeature() {
        return this.objectFeature;
    }

    @Override
    public R with(ParentSpecAndFeature<T> specAndFeature) {
        this.objectSpecification = specAndFeature.getParentSpec();
        this.objectFeature = specAndFeature.getObjectFeature();
        return AbstractTypeFeatureReprRenderer.cast(this);
    }

    @Override
    public JsonRepresentation render() {
        this.addLinkSelfIfRequired();
        this.addLinkUpToParent();
        this.addPropertiesSpecificToFeature();
        this.addLinksSpecificToFeature();
        this.putExtensionsSpecificToFeature();
        return this.representation;
    }

    protected void addPropertiesSpecificToFeature() {
    }

    protected abstract void addLinkSelfIfRequired();

    protected abstract void addLinkUpToParent();

    protected void addLinksSpecificToFeature() {
    }

    protected abstract void putExtensionsSpecificToFeature();

    protected void putExtensionsName() {
        String friendlyName = this.getObjectFeature().getName();
        this.getExtensions().mapPut("friendlyName", friendlyName);
    }

    protected void putExtensionsDescriptionIfAvailable() {
        String description = this.getObjectFeature().getDescription();
        if (!Strings.isNullOrEmpty((String)description)) {
            this.getExtensions().mapPut("description", description);
        }
    }
}

