/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.domaintypes;

import com.google.common.base.Strings;
import java.util.List;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.Rel;
import org.apache.isis.viewer.restfulobjects.applib.RepresentationType;
import org.apache.isis.viewer.restfulobjects.rendering.LinkBuilder;
import org.apache.isis.viewer.restfulobjects.rendering.LinkFollowSpecs;
import org.apache.isis.viewer.restfulobjects.rendering.RendererContext;
import org.apache.isis.viewer.restfulobjects.rendering.ReprRendererAbstract;
import org.apache.isis.viewer.restfulobjects.rendering.domaintypes.ActionDescriptionReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domaintypes.CollectionDescriptionReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domaintypes.PropertyDescriptionReprRenderer;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.NullNode;

public class DomainTypeReprRenderer
extends ReprRendererAbstract<DomainTypeReprRenderer, ObjectSpecification> {
    private ObjectSpecification objectSpecification;

    public static LinkBuilder newLinkToBuilder(RendererContext resourceContext, Rel rel, ObjectSpecification objectSpec) {
        String typeFullName = objectSpec.getSpecId().asString();
        String url = "domain-types/" + typeFullName;
        return LinkBuilder.newBuilder(resourceContext, rel.getName(), RepresentationType.DOMAIN_TYPE, url, new Object[0]);
    }

    public DomainTypeReprRenderer(RendererContext resourceContext, LinkFollowSpecs linkFollower, JsonRepresentation representation) {
        super(resourceContext, linkFollower, RepresentationType.DOMAIN_TYPE, representation);
    }

    @Override
    public DomainTypeReprRenderer with(ObjectSpecification objectSpecification) {
        this.objectSpecification = objectSpecification;
        return DomainTypeReprRenderer.cast(this);
    }

    @Override
    public JsonRepresentation render() {
        if (this.objectSpecification == null) {
            throw new IllegalStateException("ObjectSpecification not specified");
        }
        if (this.includesSelf) {
            JsonRepresentation selfLink = DomainTypeReprRenderer.newLinkToBuilder(this.getRendererContext(), Rel.SELF, this.objectSpecification).build();
            this.getLinks().arrayAdd(selfLink);
        }
        this.representation.mapPut("canonicalName", this.objectSpecification.getFullIdentifier());
        this.addMembers();
        this.addTypeActions();
        this.putExtensionsNames();
        this.putExtensionsDescriptionIfAvailable();
        this.putExtensionsIfService();
        return this.representation;
    }

    private void addMembers() {
        LinkBuilder linkBuilder;
        JsonRepresentation membersList = JsonRepresentation.newArray();
        this.representation.mapPut("members", membersList);
        List associations = this.objectSpecification.getAssociations(Contributed.EXCLUDED);
        for (ObjectAssociation association : associations) {
            if (association.isOneToOneAssociation()) {
                OneToOneAssociation property = (OneToOneAssociation)association;
                linkBuilder = PropertyDescriptionReprRenderer.newLinkToBuilder(this.getRendererContext(), Rel.PROPERTY, this.objectSpecification, property);
                membersList.arrayAdd(linkBuilder.build());
                continue;
            }
            if (!association.isOneToManyAssociation()) continue;
            OneToManyAssociation collection = (OneToManyAssociation)association;
            linkBuilder = CollectionDescriptionReprRenderer.newLinkToBuilder(this.getRendererContext(), Rel.PROPERTY, this.objectSpecification, collection);
            membersList.arrayAdd(linkBuilder.build());
        }
        List actions = this.objectSpecification.getObjectActions(Contributed.INCLUDED);
        for (ObjectAction action : actions) {
            linkBuilder = ActionDescriptionReprRenderer.newLinkToBuilder(this.getRendererContext(), Rel.ACTION, this.objectSpecification, action);
            membersList.arrayAdd(linkBuilder.build());
        }
    }

    private JsonRepresentation getTypeActions() {
        JsonRepresentation typeActions = this.representation.getArray("typeActions");
        if (typeActions == null) {
            typeActions = JsonRepresentation.newArray();
            this.representation.mapPut("typeActions", typeActions);
        }
        return typeActions;
    }

    private void addTypeActions() {
        this.getTypeActions().arrayAdd(this.linkToIsSubtypeOf());
        this.getTypeActions().arrayAdd(this.linkToIsSupertypeOf());
    }

    private JsonRepresentation linkToIsSubtypeOf() {
        String url = "domain-types/" + this.objectSpecification.getSpecId().asString() + "/type-actions/isSubtypeOf/invoke";
        LinkBuilder linkBuilder = LinkBuilder.newBuilder(this.getRendererContext(), Rel.INVOKE.andParam("typeaction", "isSubtypeOf"), RepresentationType.TYPE_ACTION_RESULT, url, new Object[0]);
        JsonRepresentation arguments = DomainTypeReprRenderer.argumentsTo(this.getRendererContext(), "supertype", null);
        JsonRepresentation link = linkBuilder.withArguments(arguments).build();
        return link;
    }

    private JsonRepresentation linkToIsSupertypeOf() {
        String url = "domain-types/" + this.objectSpecification.getSpecId().asString() + "/type-actions/isSupertypeOf/invoke";
        LinkBuilder linkBuilder = LinkBuilder.newBuilder(this.getRendererContext(), Rel.INVOKE.andParam("typeaction", "isSupertypeOf"), RepresentationType.TYPE_ACTION_RESULT, url, new Object[0]);
        JsonRepresentation arguments = DomainTypeReprRenderer.argumentsTo(this.getRendererContext(), "subtype", null);
        JsonRepresentation link = linkBuilder.withArguments(arguments).build();
        return link;
    }

    public static JsonRepresentation argumentsTo(RendererContext resourceContext, String paramName, ObjectSpecification objectSpec) {
        JsonRepresentation arguments = JsonRepresentation.newMap((String[])new String[0]);
        JsonRepresentation link = JsonRepresentation.newMap((String[])new String[0]);
        arguments.mapPut(paramName, link);
        if (objectSpec != null) {
            link.mapPut("href", resourceContext.urlFor("domain-types/" + objectSpec.getSpecId().asString()));
        } else {
            link.mapPut("href", (JsonNode)NullNode.instance);
        }
        return arguments;
    }

    protected void putExtensionsNames() {
        String singularName = this.objectSpecification.getSingularName();
        this.getExtensions().mapPut("friendlyName", singularName);
        String pluralName = this.objectSpecification.getPluralName();
        this.getExtensions().mapPut("pluralName", pluralName);
    }

    protected void putExtensionsDescriptionIfAvailable() {
        String description = this.objectSpecification.getDescription();
        if (!Strings.isNullOrEmpty((String)description)) {
            this.getExtensions().mapPut("description", description);
        }
    }

    protected void putExtensionsIfService() {
        this.getExtensions().mapPut("isService", this.objectSpecification.isService());
    }
}

