/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.domainobjects;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.isis.applib.annotation.ActionSemantics;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectActionParameter;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.Rel;
import org.apache.isis.viewer.restfulobjects.applib.RepresentationType;
import org.apache.isis.viewer.restfulobjects.rendering.LinkFollowSpecs;
import org.apache.isis.viewer.restfulobjects.rendering.RendererContext;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.AbstractObjectMemberReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.DomainObjectReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.InvokeKeys;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.MutatorSpec;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAdapterLinkTo;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAndAction;
import org.apache.isis.viewer.restfulobjects.rendering.domaintypes.ActionDescriptionReprRenderer;
import org.codehaus.jackson.node.NullNode;

public class ObjectActionReprRenderer
extends AbstractObjectMemberReprRenderer<ObjectActionReprRenderer, ObjectAction> {
    public ObjectActionReprRenderer(RendererContext resourceContext, LinkFollowSpecs linkFollowSpecs, String actionId, JsonRepresentation representation) {
        super(resourceContext, linkFollowSpecs, actionId, RepresentationType.OBJECT_ACTION, representation, Where.OBJECT_FORMS);
    }

    @Override
    public JsonRepresentation render() {
        this.renderMemberContent();
        this.putDisabledReasonIfDisabled();
        if (this.mode.isStandalone() || this.mode.isMutated()) {
            this.addParameterDetails();
        }
        return this.representation;
    }

    @Override
    protected void followDetailsLink(JsonRepresentation detailsLink) {
        ObjectActionReprRenderer renderer = new ObjectActionReprRenderer(this.getRendererContext(), this.getLinkFollowSpecs(), null, JsonRepresentation.newMap((String[])new String[0]));
        ((ObjectActionReprRenderer)((ObjectActionReprRenderer)renderer.with(new ObjectAndAction(this.objectAdapter, (ObjectAction)this.objectMember))).usingLinkTo(this.linkTo)).asFollowed();
        detailsLink.mapPut("value", renderer.render());
    }

    @Override
    protected void addMutatorsIfEnabled() {
        if (this.usability().isVetoed()) {
            return;
        }
        Map<String, MutatorSpec> mutators = this.memberType.getMutators();
        ActionSemantics.Of actionSemantics = ((ObjectAction)this.objectMember).getSemantics();
        String mutator = InvokeKeys.getKeyFor(actionSemantics);
        MutatorSpec mutatorSpec = mutators.get(mutator);
        this.addLinkFor(mutatorSpec);
    }

    @Override
    protected ObjectAdapterLinkTo linkToForMutatorInvoke() {
        return super.linkToForMutatorInvoke();
    }

    private ObjectAdapter contributingServiceAdapter() {
        ObjectSpecification serviceType = ((ObjectAction)this.objectMember).getOnType();
        List<ObjectAdapter> serviceAdapters = this.getServiceAdapters();
        for (ObjectAdapter serviceAdapter : serviceAdapters) {
            if (serviceAdapter.getSpecification() != serviceType) continue;
            return serviceAdapter;
        }
        throw new IllegalStateException("Unable to locate contributing service");
    }

    @Override
    protected JsonRepresentation mutatorArgs(MutatorSpec mutatorSpec) {
        JsonRepresentation argMap = JsonRepresentation.newMap((String[])new String[0]);
        List parameters = ((ObjectAction)this.objectMember).getParameters();
        for (int i = 0; i < ((ObjectAction)this.objectMember).getParameterCount(); ++i) {
            argMap.mapPut(((ObjectActionParameter)parameters.get(i)).getId() + ".value", this.argValueFor(i));
        }
        return argMap;
    }

    private Object argValueFor(int i) {
        return NullNode.getInstance();
    }

    private ObjectActionReprRenderer addParameterDetails() {
        boolean gsoc2013 = this.getRendererContext().getConfiguration().getBoolean("isis.viewer.restfulobjects.gsoc2013.legacyParamDetails", false);
        if (gsoc2013) {
            ArrayList parameters = Lists.newArrayList();
            for (int i = 0; i < ((ObjectAction)this.objectMember).getParameterCount(); ++i) {
                ObjectActionParameter param = (ObjectActionParameter)((ObjectAction)this.objectMember).getParameters().get(i);
                Object paramDetails = this.paramDetails(param);
                parameters.add(paramDetails);
            }
            this.representation.mapPut("parameters", (List)parameters);
        } else {
            LinkedHashMap parameters = Maps.newLinkedHashMap();
            for (int i = 0; i < ((ObjectAction)this.objectMember).getParameterCount(); ++i) {
                ObjectActionParameter param = (ObjectActionParameter)((ObjectAction)this.objectMember).getParameters().get(i);
                Object paramDetails = this.paramDetails(param);
                parameters.put(param.getId(), paramDetails);
            }
            this.representation.mapPut("parameters", (Object)parameters);
        }
        return this;
    }

    private Object paramDetails(ObjectActionParameter param) {
        Object paramDefault;
        JsonRepresentation paramRep = JsonRepresentation.newMap((String[])new String[0]);
        paramRep.mapPut("num", param.getNumber());
        paramRep.mapPut("id", param.getId());
        paramRep.mapPut("name", param.getName());
        paramRep.mapPut("description", param.getDescription());
        Object paramChoices = this.choicesFor(param);
        if (paramChoices != null) {
            paramRep.mapPut("choices", paramChoices);
        }
        if ((paramDefault = this.defaultFor(param)) != null) {
            paramRep.mapPut("default", paramDefault);
        }
        return paramRep;
    }

    private Object choicesFor(ObjectActionParameter param) {
        ObjectAdapter[] choiceAdapters = param.getChoices(this.objectAdapter, null);
        if (choiceAdapters == null || choiceAdapters.length == 0) {
            return null;
        }
        ArrayList list = Lists.newArrayList();
        for (ObjectAdapter choiceAdapter : choiceAdapters) {
            ObjectSpecification choiceSpec = choiceAdapter.getSpecification();
            list.add(DomainObjectReprRenderer.valueOrRef(this.rendererContext, choiceAdapter, choiceSpec));
        }
        return list;
    }

    private Object defaultFor(ObjectActionParameter param) {
        ObjectAdapter defaultAdapter = param.getDefault(this.objectAdapter);
        if (defaultAdapter == null) {
            return null;
        }
        ObjectSpecification defaultSpec = defaultAdapter.getSpecification();
        return DomainObjectReprRenderer.valueOrRef(this.rendererContext, defaultAdapter, defaultSpec);
    }

    @Override
    protected void addLinksToFormalDomainModel() {
        this.getLinks().arrayAdd(ActionDescriptionReprRenderer.newLinkToBuilder(this.rendererContext, Rel.DESCRIBEDBY, this.objectAdapter.getSpecification(), (ObjectAction)this.objectMember).build());
    }

    @Override
    protected void addLinksIsisProprietary() {
    }

    @Override
    protected void putExtensionsIsisProprietary() {
        this.getExtensions().mapPut("actionType", ((ObjectAction)this.objectMember).getType().name().toLowerCase());
        ActionSemantics.Of semantics = ((ObjectAction)this.objectMember).getSemantics();
        this.getExtensions().mapPut("actionSemantics", semantics.getCamelCaseName());
    }
}

