/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.domainobjects;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.facets.object.encodeable.EncodableFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.JsonValueEncoder;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class JsonValueEncoderTest_appendValueAndFormat {
    private final Mockery context = new JUnit4Mockery();
    private JsonRepresentation representation;
    private ObjectSpecification mockObjectSpec;
    private EncodableFacet mockEncodableFacet;
    private ObjectAdapter mockObjectAdapter;
    private AdapterManager mockAdapterManager;

    @Before
    public void setUp() throws Exception {
        this.mockObjectSpec = (ObjectSpecification)this.context.mock(ObjectSpecification.class);
        this.mockEncodableFacet = (EncodableFacet)this.context.mock(EncodableFacet.class);
        this.mockObjectAdapter = (ObjectAdapter)this.context.mock(ObjectAdapter.class);
        this.mockAdapterManager = (AdapterManager)this.context.mock(AdapterManager.class);
        JsonValueEncoder.testSetAdapterManager((AdapterManager)this.mockAdapterManager);
        this.representation = JsonRepresentation.newMap((String[])new String[0]);
    }

    @After
    public void tearDown() throws Exception {
        JsonValueEncoder.testSetAdapterManager(null);
    }

    @Test
    public void whenString() throws Exception {
        this.allowingObjectSpecToReturnSpecIdFor(String.class);
        this.allowingObjectAdapterToReturn("aString");
        JsonValueEncoder.appendValueAndFormat((ObjectSpecification)this.mockObjectSpec, (ObjectAdapter)this.mockObjectAdapter, (JsonRepresentation)this.representation, null);
        Assert.assertThat((Object)this.representation.isString("value"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.representation.getString("value"), (Matcher)Matchers.is((Object)"aString"));
        Assert.assertThat((Object)this.representation.getString("format"), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)this.representation.getString("extensions.x-isis-format"), (Matcher)Matchers.is((Object)"string"));
    }

    @Test
    public void whenBooleanWrapper() throws Exception {
        this.allowingObjectSpecToReturnSpecIdFor(Boolean.class);
        this.allowingObjectAdapterToReturn(Boolean.TRUE);
        JsonValueEncoder.appendValueAndFormat((ObjectSpecification)this.mockObjectSpec, (ObjectAdapter)this.mockObjectAdapter, (JsonRepresentation)this.representation, null);
        Assert.assertThat((Object)this.representation.isBoolean("value"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.representation.getBoolean("value"), (Matcher)Matchers.is((Object)Boolean.TRUE));
        Assert.assertThat((Object)this.representation.getString("format"), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void whenBooleanPrimitive() throws Exception {
        this.allowingObjectSpecToReturnSpecIdFor(Boolean.TYPE);
        this.allowingObjectAdapterToReturn(true);
        JsonValueEncoder.appendValueAndFormat((ObjectSpecification)this.mockObjectSpec, (ObjectAdapter)this.mockObjectAdapter, (JsonRepresentation)this.representation, null);
        Assert.assertThat((Object)this.representation.isBoolean("value"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.representation.getBoolean("value"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.representation.getString("format"), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void whenByteWrapper() throws Exception {
        this.allowingObjectSpecToReturnSpecIdFor(Byte.class);
        this.allowingObjectAdapterToReturn((byte)123);
        JsonValueEncoder.appendValueAndFormat((ObjectSpecification)this.mockObjectSpec, (ObjectAdapter)this.mockObjectAdapter, (JsonRepresentation)this.representation, null);
        Assert.assertThat((Object)this.representation.isIntegralNumber("value"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.representation.getByte("value"), (Matcher)Matchers.is((Object)123));
        Assert.assertThat((Object)this.representation.getString("format"), (Matcher)Matchers.is((Object)"int"));
        Assert.assertThat((Object)this.representation.getString("extensions.x-isis-format"), (Matcher)Matchers.is((Object)"byte"));
    }

    @Test
    public void whenBytePrimitive() throws Exception {
        this.allowingObjectSpecToReturnSpecIdFor(Byte.TYPE);
        this.allowingObjectAdapterToReturn((byte)123);
        JsonValueEncoder.appendValueAndFormat((ObjectSpecification)this.mockObjectSpec, (ObjectAdapter)this.mockObjectAdapter, (JsonRepresentation)this.representation, null);
        Assert.assertThat((Object)this.representation.isIntegralNumber("value"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.representation.getByte("value"), (Matcher)Matchers.is((Object)123));
        Assert.assertThat((Object)this.representation.getString("format"), (Matcher)Matchers.is((Object)"int"));
        Assert.assertThat((Object)this.representation.getString("extensions.x-isis-format"), (Matcher)Matchers.is((Object)"byte"));
    }

    @Test
    public void whenShortWrapper() throws Exception {
        this.allowingObjectSpecToReturnSpecIdFor(Short.class);
        this.allowingObjectAdapterToReturn((short)12345);
        JsonValueEncoder.appendValueAndFormat((ObjectSpecification)this.mockObjectSpec, (ObjectAdapter)this.mockObjectAdapter, (JsonRepresentation)this.representation, null);
        Assert.assertThat((Object)this.representation.isIntegralNumber("value"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.representation.getShort("value"), (Matcher)Matchers.is((Object)12345));
        Assert.assertThat((Object)this.representation.getString("format"), (Matcher)Matchers.is((Object)"int"));
        Assert.assertThat((Object)this.representation.getString("extensions.x-isis-format"), (Matcher)Matchers.is((Object)"short"));
    }

    @Test
    public void whenShortPrimitive() throws Exception {
        this.allowingObjectSpecToReturnSpecIdFor(Short.TYPE);
        this.allowingObjectAdapterToReturn((short)12345);
        JsonValueEncoder.appendValueAndFormat((ObjectSpecification)this.mockObjectSpec, (ObjectAdapter)this.mockObjectAdapter, (JsonRepresentation)this.representation, null);
        Assert.assertThat((Object)this.representation.isIntegralNumber("value"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.representation.getShort("value"), (Matcher)Matchers.is((Object)12345));
        Assert.assertThat((Object)this.representation.getString("format"), (Matcher)Matchers.is((Object)"int"));
        Assert.assertThat((Object)this.representation.getString("extensions.x-isis-format"), (Matcher)Matchers.is((Object)"short"));
    }

    @Test
    public void whenIntWrapper() throws Exception {
        this.allowingObjectSpecToReturnSpecIdFor(Integer.class);
        this.allowingObjectAdapterToReturn(12345678);
        JsonValueEncoder.appendValueAndFormat((ObjectSpecification)this.mockObjectSpec, (ObjectAdapter)this.mockObjectAdapter, (JsonRepresentation)this.representation, null);
        Assert.assertThat((Object)this.representation.isIntegralNumber("value"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.representation.getInt("value"), (Matcher)Matchers.is((Object)12345678));
        Assert.assertThat((Object)this.representation.getString("format"), (Matcher)Matchers.is((Object)"int"));
        Assert.assertThat((Object)this.representation.getString("extensions.x-isis-format"), (Matcher)Matchers.is((Object)"int"));
    }

    @Test
    public void whenIntPrimitive() throws Exception {
        this.allowingObjectSpecToReturnSpecIdFor(Integer.TYPE);
        this.allowingObjectAdapterToReturn(12345678);
        JsonValueEncoder.appendValueAndFormat((ObjectSpecification)this.mockObjectSpec, (ObjectAdapter)this.mockObjectAdapter, (JsonRepresentation)this.representation, null);
        Assert.assertThat((Object)this.representation.isIntegralNumber("value"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.representation.getInt("value"), (Matcher)Matchers.is((Object)12345678));
        Assert.assertThat((Object)this.representation.getString("format"), (Matcher)Matchers.is((Object)"int"));
        Assert.assertThat((Object)this.representation.getString("extensions.x-isis-format"), (Matcher)Matchers.is((Object)"int"));
    }

    @Test
    public void whenLongWrapper() throws Exception {
        this.allowingObjectSpecToReturnSpecIdFor(Long.class);
        this.allowingObjectAdapterToReturn(12345678901234L);
        JsonValueEncoder.appendValueAndFormat((ObjectSpecification)this.mockObjectSpec, (ObjectAdapter)this.mockObjectAdapter, (JsonRepresentation)this.representation, null);
        Assert.assertThat((Object)this.representation.isIntegralNumber("value"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.representation.getLong("value"), (Matcher)Matchers.is((Object)12345678901234L));
        Assert.assertThat((Object)this.representation.getString("format"), (Matcher)Matchers.is((Object)"int"));
        Assert.assertThat((Object)this.representation.getString("extensions.x-isis-format"), (Matcher)Matchers.is((Object)"long"));
    }

    @Test
    public void whenLongPrimitive() throws Exception {
        this.allowingObjectSpecToReturnSpecIdFor(Long.TYPE);
        this.allowingObjectAdapterToReturn(12345678901234L);
        JsonValueEncoder.appendValueAndFormat((ObjectSpecification)this.mockObjectSpec, (ObjectAdapter)this.mockObjectAdapter, (JsonRepresentation)this.representation, null);
        Assert.assertThat((Object)this.representation.isIntegralNumber("value"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.representation.getLong("value"), (Matcher)Matchers.is((Object)12345678901234L));
        Assert.assertThat((Object)this.representation.getString("format"), (Matcher)Matchers.is((Object)"int"));
        Assert.assertThat((Object)this.representation.getString("extensions.x-isis-format"), (Matcher)Matchers.is((Object)"long"));
    }

    @Test
    public void whenFloatWrapper() throws Exception {
        this.allowingObjectSpecToReturnSpecIdFor(Float.class);
        this.allowingObjectAdapterToReturn(Float.valueOf(123.45f));
        JsonValueEncoder.appendValueAndFormat((ObjectSpecification)this.mockObjectSpec, (ObjectAdapter)this.mockObjectAdapter, (JsonRepresentation)this.representation, null);
        Assert.assertThat((Object)this.representation.isDecimal("value"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.representation.getFloat("value"), (Matcher)Matchers.is((Object)Float.valueOf(123.45f)));
        Assert.assertThat((Object)this.representation.getString("format"), (Matcher)Matchers.is((Object)"decimal"));
        Assert.assertThat((Object)this.representation.getString("extensions.x-isis-format"), (Matcher)Matchers.is((Object)"float"));
    }

    @Test
    public void whenFloatPrimitive() throws Exception {
        this.allowingObjectSpecToReturnSpecIdFor(Float.class);
        this.allowingObjectAdapterToReturn(Float.valueOf(123.45f));
        JsonValueEncoder.appendValueAndFormat((ObjectSpecification)this.mockObjectSpec, (ObjectAdapter)this.mockObjectAdapter, (JsonRepresentation)this.representation, null);
        Assert.assertThat((Object)this.representation.isDecimal("value"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.representation.getFloat("value"), (Matcher)Matchers.is((Object)Float.valueOf(123.45f)));
        Assert.assertThat((Object)this.representation.getString("format"), (Matcher)Matchers.is((Object)"decimal"));
        Assert.assertThat((Object)this.representation.getString("extensions.x-isis-format"), (Matcher)Matchers.is((Object)"float"));
    }

    @Test
    public void whenDoubleWrapper() throws Exception {
        this.allowingObjectSpecToReturnSpecIdFor(Double.class);
        this.allowingObjectAdapterToReturn(12345.6789);
        JsonValueEncoder.appendValueAndFormat((ObjectSpecification)this.mockObjectSpec, (ObjectAdapter)this.mockObjectAdapter, (JsonRepresentation)this.representation, null);
        Assert.assertThat((Object)this.representation.isDecimal("value"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.representation.getDouble("value"), (Matcher)Matchers.is((Object)12345.6789));
        Assert.assertThat((Object)this.representation.getString("format"), (Matcher)Matchers.is((Object)"decimal"));
        Assert.assertThat((Object)this.representation.getString("extensions.x-isis-format"), (Matcher)Matchers.is((Object)"double"));
    }

    @Test
    public void whenDoublePrimitive() throws Exception {
        this.allowingObjectSpecToReturnSpecIdFor(Double.TYPE);
        this.allowingObjectAdapterToReturn(12345.6789);
        JsonValueEncoder.appendValueAndFormat((ObjectSpecification)this.mockObjectSpec, (ObjectAdapter)this.mockObjectAdapter, (JsonRepresentation)this.representation, null);
        Assert.assertThat((Object)this.representation.isDecimal("value"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.representation.getDouble("value"), (Matcher)Matchers.is((Object)12345.6789));
        Assert.assertThat((Object)this.representation.getString("format"), (Matcher)Matchers.is((Object)"decimal"));
        Assert.assertThat((Object)this.representation.getString("extensions.x-isis-format"), (Matcher)Matchers.is((Object)"double"));
    }

    @Test
    public void whenCharWrapper() throws Exception {
        this.allowingObjectSpecToReturnSpecIdFor(Character.class);
        this.allowingObjectAdapterToReturn(Character.valueOf('a'));
        JsonValueEncoder.appendValueAndFormat((ObjectSpecification)this.mockObjectSpec, (ObjectAdapter)this.mockObjectAdapter, (JsonRepresentation)this.representation, null);
        Assert.assertThat((Object)this.representation.isString("value"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.representation.getChar("value"), (Matcher)Matchers.is((Object)Character.valueOf('a')));
        Assert.assertThat((Object)this.representation.getString("format"), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)this.representation.getString("extensions.x-isis-format"), (Matcher)Matchers.is((Object)"char"));
    }

    @Test
    public void whenCharPrimitive() throws Exception {
        this.allowingObjectSpecToReturnSpecIdFor(Character.TYPE);
        this.allowingObjectAdapterToReturn(Character.valueOf('a'));
        JsonValueEncoder.appendValueAndFormat((ObjectSpecification)this.mockObjectSpec, (ObjectAdapter)this.mockObjectAdapter, (JsonRepresentation)this.representation, null);
        Assert.assertThat((Object)this.representation.isString("value"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.representation.getChar("value"), (Matcher)Matchers.is((Object)Character.valueOf('a')));
        Assert.assertThat((Object)this.representation.getString("format"), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)this.representation.getString("extensions.x-isis-format"), (Matcher)Matchers.is((Object)"char"));
    }

    @Test
    public void whenJavaUtilDate() throws Exception {
        this.allowingObjectSpecToReturnSpecIdFor(java.util.Date.class);
        this.allowingObjectAdapterToReturn(JsonValueEncoderTest_appendValueAndFormat.asDateTime("2014-04-25T12:34:45Z"));
        JsonValueEncoder.appendValueAndFormat((ObjectSpecification)this.mockObjectSpec, (ObjectAdapter)this.mockObjectAdapter, (JsonRepresentation)this.representation, null);
        Assert.assertThat((Object)this.representation.isString("value"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.representation.getString("value"), (Matcher)Matchers.is((Object)"2014-04-25T12:34:45Z"));
        Assert.assertThat((Object)this.representation.getString("format"), (Matcher)Matchers.is((Object)"date-time"));
        Assert.assertThat((Object)this.representation.getString("extensions.x-isis-format"), (Matcher)Matchers.is((Object)"javautildate"));
    }

    @Test
    public void whenJavaSqlDate() throws Exception {
        this.allowingObjectSpecToReturnSpecIdFor(Date.class);
        this.allowingObjectAdapterToReturn(JsonValueEncoderTest_appendValueAndFormat.asSqlDate("2014-04-25"));
        JsonValueEncoder.appendValueAndFormat((ObjectSpecification)this.mockObjectSpec, (ObjectAdapter)this.mockObjectAdapter, (JsonRepresentation)this.representation, null);
        Assert.assertThat((Object)this.representation.isString("value"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.representation.getString("value"), (Matcher)Matchers.is((Object)"2014-04-25"));
        Assert.assertThat((Object)this.representation.getString("format"), (Matcher)Matchers.is((Object)"date"));
        Assert.assertThat((Object)this.representation.getString("extensions.x-isis-format"), (Matcher)Matchers.is((Object)"javasqldate"));
    }

    @Test
    public void whenJodaDateTime() throws Exception {
        this.allowingObjectSpecToReturnSpecIdFor(DateTime.class);
        this.allowingObjectAdapterToReturn(new DateTime((Object)JsonValueEncoderTest_appendValueAndFormat.asDateTime("2014-04-25T12:34:45Z")));
        JsonValueEncoder.appendValueAndFormat((ObjectSpecification)this.mockObjectSpec, (ObjectAdapter)this.mockObjectAdapter, (JsonRepresentation)this.representation, null);
        Assert.assertThat((Object)this.representation.isString("value"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.representation.getString("value"), (Matcher)Matchers.is((Object)"2014-04-25T12:34:45Z"));
        Assert.assertThat((Object)this.representation.getString("format"), (Matcher)Matchers.is((Object)"date-time"));
        Assert.assertThat((Object)this.representation.getString("extensions.x-isis-format"), (Matcher)Matchers.is((Object)"jodadatetime"));
    }

    @Test
    public void whenJodaLocalDateTime() throws Exception {
        this.allowingObjectSpecToReturnSpecIdFor(LocalDateTime.class);
        this.allowingObjectAdapterToReturn(new LocalDateTime((Object)JsonValueEncoderTest_appendValueAndFormat.asDateTime("2014-04-25T12:34:45Z")));
        JsonValueEncoder.appendValueAndFormat((ObjectSpecification)this.mockObjectSpec, (ObjectAdapter)this.mockObjectAdapter, (JsonRepresentation)this.representation, null);
        Assert.assertThat((Object)this.representation.isString("value"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.representation.getString("value"), (Matcher)Matchers.is((Object)"2014-04-25T12:34:45Z"));
        Assert.assertThat((Object)this.representation.getString("format"), (Matcher)Matchers.is((Object)"date-time"));
        Assert.assertThat((Object)this.representation.getString("extensions.x-isis-format"), (Matcher)Matchers.is((Object)"jodalocaldatetime"));
    }

    @Test
    public void whenJodaLocalDate() throws Exception {
        this.allowingObjectSpecToReturnSpecIdFor(LocalDate.class);
        this.allowingObjectAdapterToReturn(new LocalDate(2014, 4, 25));
        JsonValueEncoder.appendValueAndFormat((ObjectSpecification)this.mockObjectSpec, (ObjectAdapter)this.mockObjectAdapter, (JsonRepresentation)this.representation, null);
        Assert.assertThat((Object)this.representation.isString("value"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.representation.getString("value"), (Matcher)Matchers.is((Object)"2014-04-25"));
        Assert.assertThat((Object)this.representation.getString("format"), (Matcher)Matchers.is((Object)"date"));
        Assert.assertThat((Object)this.representation.getString("extensions.x-isis-format"), (Matcher)Matchers.is((Object)"jodalocaldate"));
    }

    @Test
    public void whenJavaSqlTimestamp() throws Exception {
        this.allowingObjectSpecToReturnSpecIdFor(Timestamp.class);
        long time = JsonValueEncoderTest_appendValueAndFormat.asDateTime("2014-04-25T12:34:45Z").getTime();
        this.allowingObjectAdapterToReturn(new Timestamp(time));
        JsonValueEncoder.appendValueAndFormat((ObjectSpecification)this.mockObjectSpec, (ObjectAdapter)this.mockObjectAdapter, (JsonRepresentation)this.representation, null);
        Assert.assertThat((Object)this.representation.isLong("value"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.representation.getLong("value"), (Matcher)Matchers.is((Object)time));
        Assert.assertThat((Object)this.representation.getString("format"), (Matcher)Matchers.is((Object)"utc-millisec"));
        Assert.assertThat((Object)this.representation.getString("extensions.x-isis-format"), (Matcher)Matchers.is((Object)"javasqltimestamp"));
    }

    @Test
    public void whenBigInteger() throws Exception {
        this.allowingObjectSpecToReturnSpecIdFor(BigInteger.class);
        this.allowingObjectAdapterToReturn(new BigInteger("12345678901234567890"));
        JsonValueEncoder.appendValueAndFormat((ObjectSpecification)this.mockObjectSpec, (ObjectAdapter)this.mockObjectAdapter, (JsonRepresentation)this.representation, (String)"big-integer(22)");
        Assert.assertThat((Object)this.representation.isString("value"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.representation.isBigInteger("value"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.representation.getBigInteger("value"), (Matcher)Matchers.is((Object)new BigInteger("12345678901234567890")));
        Assert.assertThat((Object)this.representation.getString("format"), (Matcher)Matchers.is((Object)"big-integer(22)"));
        Assert.assertThat((Object)this.representation.getString("extensions.x-isis-format"), (Matcher)Matchers.is((Object)"javamathbiginteger"));
    }

    @Test
    public void whenBigDecimal() throws Exception {
        this.allowingObjectSpecToReturnSpecIdFor(BigDecimal.class);
        this.allowingObjectAdapterToReturn(new BigDecimal("12345678901234567890.1234"));
        JsonValueEncoder.appendValueAndFormat((ObjectSpecification)this.mockObjectSpec, (ObjectAdapter)this.mockObjectAdapter, (JsonRepresentation)this.representation, (String)"big-decimal(27,4)");
        Assert.assertThat((Object)this.representation.isString("value"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.representation.isBigDecimal("value"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.representation.getBigDecimal("value"), (Matcher)Matchers.is((Object)new BigDecimal("12345678901234567890.1234")));
        Assert.assertThat((Object)this.representation.getString("format"), (Matcher)Matchers.is((Object)"big-decimal(27,4)"));
        Assert.assertThat((Object)this.representation.getString("extensions.x-isis-format"), (Matcher)Matchers.is((Object)"javamathbigdecimal"));
    }

    private void allowingObjectSpecToReturnSpecIdFor(final Class<?> cls) {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ObjectSpecification)this.oneOf(JsonValueEncoderTest_appendValueAndFormat.this.mockObjectSpec)).getSpecId();
                this.will(1.returnValue((Object)new ObjectSpecId(cls.getName())));
            }
        });
    }

    private void allowingObjectAdapterToReturn(final Object pojo) {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ObjectAdapter)this.oneOf(JsonValueEncoderTest_appendValueAndFormat.this.mockObjectAdapter)).getObject();
                this.will(2.returnValue((Object)pojo));
            }
        });
    }

    private static Date asSqlDate(String text) {
        return new Date(JsonRepresentation.yyyyMMdd.parseDateTime(text).getMillis());
    }

    private static java.util.Date asDateTime(String text) {
        return new java.util.Date(JsonRepresentation.yyyyMMddTHHmmssZ.parseDateTime(text).getMillis());
    }
}

