/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.domainobjects;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Map;
import org.apache.isis.applib.annotation.Render;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.members.resolve.RenderFacet;
import org.apache.isis.core.metamodel.facets.object.title.TitleFacet;
import org.apache.isis.core.metamodel.facets.object.value.ValueFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.core.progmodel.facets.value.bigdecimal.BigDecimalValueFacet;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.Rel;
import org.apache.isis.viewer.restfulobjects.applib.RepresentationType;
import org.apache.isis.viewer.restfulobjects.rendering.LinkBuilder;
import org.apache.isis.viewer.restfulobjects.rendering.LinkFollowSpecs;
import org.apache.isis.viewer.restfulobjects.rendering.RendererContext;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.AbstractObjectMemberReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.DomainObjectReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.JsonValueEncoder;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.MutatorSpec;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAndProperty;
import org.apache.isis.viewer.restfulobjects.rendering.domaintypes.PropertyDescriptionReprRenderer;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.NullNode;

public class ObjectPropertyReprRenderer
extends AbstractObjectMemberReprRenderer<ObjectPropertyReprRenderer, OneToOneAssociation> {
    public ObjectPropertyReprRenderer(RendererContext resourceContext, LinkFollowSpecs linkFollower, String propertyId, JsonRepresentation representation) {
        super(resourceContext, linkFollower, propertyId, RepresentationType.OBJECT_PROPERTY, representation, Where.OBJECT_FORMS);
    }

    @Override
    public JsonRepresentation render() {
        this.renderMemberContent();
        this.addValue();
        this.putDisabledReasonIfDisabled();
        if (this.mode.isStandalone() || this.mode.isMutated()) {
            this.addChoices();
            this.addExtensionsIsisProprietaryChangedObjects();
        }
        return this.representation;
    }

    private void addValue() {
        boolean eagerlyRender;
        ObjectAdapter valueAdapter = ((OneToOneAssociation)this.objectMember).get(this.objectAdapter);
        ObjectSpecification spec = valueAdapter != null ? valueAdapter.getSpecification() : ((OneToOneAssociation)this.objectMember).getSpecification();
        ValueFacet valueFacet = (ValueFacet)spec.getFacet(ValueFacet.class);
        if (valueFacet != null) {
            String format = null;
            Class specClass = spec.getCorrespondingClass();
            if (specClass == BigDecimal.class) {
                BigDecimalValueFacet bigDecimalValueFacet = ObjectPropertyReprRenderer.getFacet(BigDecimalValueFacet.class, new FacetHolder[]{this.objectMember, valueAdapter != null ? valueAdapter.getSpecification() : null});
                if (bigDecimalValueFacet != null) {
                    Integer precision = bigDecimalValueFacet.getPrecision();
                    Integer scale = bigDecimalValueFacet.getScale();
                    format = String.format("big-decimal(%d,%d)", precision, scale);
                }
            } else if (specClass == BigInteger.class) {
                // empty if block
            }
            JsonValueEncoder.appendValueAndFormat(spec, valueAdapter, this.representation, format);
            return;
        }
        RenderFacet renderFacet = (RenderFacet)((OneToOneAssociation)this.objectMember).getFacet(RenderFacet.class);
        boolean bl = eagerlyRender = renderFacet != null && renderFacet.value() == Render.Type.EAGERLY && this.rendererContext.canEagerlyRender(valueAdapter);
        if (valueAdapter == null) {
            this.representation.mapPut("value", (JsonNode)NullNode.getInstance());
        } else {
            TitleFacet titleFacet = (TitleFacet)spec.getFacet(TitleFacet.class);
            String title = titleFacet.title(valueAdapter, this.rendererContext.getLocalization());
            LinkBuilder valueLinkBuilder = DomainObjectReprRenderer.newLinkToBuilder(this.rendererContext, Rel.VALUE, valueAdapter).withTitle(title);
            if (eagerlyRender) {
                DomainObjectReprRenderer renderer = new DomainObjectReprRenderer(this.rendererContext, this.getLinkFollowSpecs(), JsonRepresentation.newMap((String[])new String[0]));
                renderer.with(valueAdapter);
                if (this.mode.isEventSerialization()) {
                    renderer.asEventSerialization();
                }
                valueLinkBuilder.withValue(renderer.render());
            }
            this.representation.mapPut("value", valueLinkBuilder.build());
        }
    }

    private static <T extends Facet> T getFacet(Class<T> facetType, FacetHolder ... holders) {
        for (FacetHolder holder : holders) {
            Facet facet;
            if (holder == null || (facet = holder.getFacet(facetType)) == null) continue;
            return (T)facet;
        }
        return null;
    }

    @Override
    protected void followDetailsLink(JsonRepresentation detailsLink) {
        ObjectPropertyReprRenderer renderer = new ObjectPropertyReprRenderer(this.getRendererContext(), this.getLinkFollowSpecs(), null, JsonRepresentation.newMap((String[])new String[0]));
        ((ObjectPropertyReprRenderer)renderer.with(new ObjectAndProperty(this.objectAdapter, (OneToOneAssociation)this.objectMember))).asFollowed();
        detailsLink.mapPut("value", renderer.render());
    }

    @Override
    protected void addMutatorsIfEnabled() {
        if (this.usability().isVetoed()) {
            return;
        }
        Map<String, MutatorSpec> mutators = this.objectMemberType.getMutators();
        for (String mutator : mutators.keySet()) {
            MutatorSpec mutatorSpec = mutators.get(mutator);
            this.addLinkFor(mutatorSpec);
        }
    }

    private ObjectPropertyReprRenderer addChoices() {
        Object propertyChoices = this.propertyChoices();
        if (propertyChoices != null) {
            this.representation.mapPut("choices", propertyChoices);
        }
        return this;
    }

    private Object propertyChoices() {
        ObjectAdapter[] choiceAdapters = ((OneToOneAssociation)this.objectMember).getChoices(this.objectAdapter);
        if (choiceAdapters == null || choiceAdapters.length == 0) {
            return null;
        }
        ArrayList list = Lists.newArrayList();
        for (ObjectAdapter choiceAdapter : choiceAdapters) {
            ObjectSpecification choiceSpec = this.objectAdapter.getSpecification();
            list.add(DomainObjectReprRenderer.valueOrRef(this.rendererContext, choiceAdapter, choiceSpec));
        }
        return list;
    }

    @Override
    protected void addLinksToFormalDomainModel() {
        this.getLinks().arrayAdd(PropertyDescriptionReprRenderer.newLinkToBuilder(this.getRendererContext(), Rel.DESCRIBEDBY, this.objectAdapter.getSpecification(), (OneToOneAssociation)this.objectMember).build());
    }

    @Override
    protected void addLinksIsisProprietary() {
    }

    @Override
    protected void putExtensionsIsisProprietary() {
    }
}

