/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.domaintypes;

import java.util.List;
import org.apache.isis.core.metamodel.facets.typeof.TypeOfFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectActionParameter;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.Rel;
import org.apache.isis.viewer.restfulobjects.applib.RepresentationType;
import org.apache.isis.viewer.restfulobjects.rendering.LinkBuilder;
import org.apache.isis.viewer.restfulobjects.rendering.LinkFollowSpecs;
import org.apache.isis.viewer.restfulobjects.rendering.RendererContext;
import org.apache.isis.viewer.restfulobjects.rendering.domaintypes.AbstractTypeMemberReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domaintypes.ActionParameterDescriptionReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domaintypes.DomainTypeReprRenderer;

public class ActionDescriptionReprRenderer
extends AbstractTypeMemberReprRenderer<ActionDescriptionReprRenderer, ObjectAction> {
    public static LinkBuilder newLinkToBuilder(RendererContext resourceContext, Rel rel, ObjectSpecification objectSpecification, ObjectAction objectAction) {
        String domainType = objectSpecification.getSpecId().asString();
        String actionId = objectAction.getId();
        String url = "domain-types/" + domainType + "/actions/" + actionId;
        return LinkBuilder.newBuilder(resourceContext, rel.getName(), RepresentationType.ACTION_DESCRIPTION, url, new Object[0]);
    }

    public ActionDescriptionReprRenderer(RendererContext resourceContext, LinkFollowSpecs linkFollower, JsonRepresentation representation) {
        super(resourceContext, linkFollower, RepresentationType.ACTION_DESCRIPTION, representation);
    }

    @Override
    protected void addLinksSpecificToFeature() {
        this.addParameters();
        this.addLinkToReturnTypeIfAny();
        this.addLinkToElementTypeIfAny();
    }

    private void addParameters() {
        JsonRepresentation parameterList = JsonRepresentation.newArray();
        List parameters = ((ObjectAction)this.getObjectFeature()).getParameters();
        for (ObjectActionParameter parameter : parameters) {
            LinkBuilder linkBuilder = ActionParameterDescriptionReprRenderer.newLinkToBuilder(this.getRendererContext(), Rel.ACTION_PARAM, this.objectSpecification, parameter);
            parameterList.arrayAdd(linkBuilder.build());
        }
        this.representation.mapPut("parameters", parameterList);
    }

    protected void addLinkToElementTypeIfAny() {
        TypeOfFacet facet = (TypeOfFacet)((ObjectAction)this.getObjectFeature()).getFacet(TypeOfFacet.class);
        if (facet == null) {
            return;
        }
        ObjectSpecification typeOfSpec = facet.valueSpec();
        LinkBuilder linkBuilder = DomainTypeReprRenderer.newLinkToBuilder(this.getRendererContext(), Rel.ELEMENT_TYPE, typeOfSpec);
        this.getLinks().arrayAdd(linkBuilder.build());
    }

    private void addLinkToReturnTypeIfAny() {
        ObjectSpecification returnType = ((ObjectAction)this.getObjectFeature()).getReturnType();
        if (returnType == null) {
            return;
        }
        LinkBuilder linkBuilder = DomainTypeReprRenderer.newLinkToBuilder(this.getRendererContext(), Rel.RETURN_TYPE, returnType);
        this.getLinks().arrayAdd(linkBuilder.build());
    }

    @Override
    protected void putExtensionsSpecificToFeature() {
        this.putExtensionsName();
        this.putExtensionsDescriptionIfAvailable();
    }
}

