/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.eventserializer;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.profiles.Localization;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.viewer.restfulobjects.rendering.RendererContext;

public class EventSerializerRendererContext
implements RendererContext {
    private final String baseUrl;
    private final Where where;
    private Set<Oid> rendered = Sets.newHashSet();

    public EventSerializerRendererContext(String baseUrl, Where where) {
        this.baseUrl = baseUrl;
        this.where = where;
    }

    @Override
    public String urlFor(String url) {
        return this.baseUrl + url;
    }

    @Override
    public AuthenticationSession getAuthenticationSession() {
        return IsisContext.getAuthenticationSession();
    }

    @Override
    public PersistenceSession getPersistenceSession() {
        return IsisContext.getPersistenceSession();
    }

    @Override
    public IsisConfiguration getConfiguration() {
        return IsisContext.getConfiguration();
    }

    @Override
    public AdapterManager getAdapterManager() {
        return this.getPersistenceSession().getAdapterManager();
    }

    @Override
    public List<List<String>> getFollowLinks() {
        return Collections.emptyList();
    }

    @Override
    public Where getWhere() {
        return this.where;
    }

    @Override
    public Localization getLocalization() {
        return IsisContext.getLocalization();
    }

    @Override
    public boolean canEagerlyRender(ObjectAdapter objectAdapter) {
        Oid oid = objectAdapter.getOid();
        return this.rendered.add(oid);
    }
}

