/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.scimpi.servlet;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.isis.core.commons.debug.DebugString;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.log4j.Logger;

public class ImageLookup {
    private static final Logger LOG = Logger.getLogger(ImageLookup.class);
    private static final String UNKNOWN_IMAGE = "Default";
    private static final String[] EXTENSIONS = new String[]{"png", "gif", "jpg", "jpeg"};
    private static final Map images = new HashMap();
    private static String imageDirectory;
    private static ServletContext context;

    public static void setImageDirectory(ServletContext context, String imageDirectory) {
        LOG.debug((Object)("image directory required for: " + imageDirectory));
        ImageLookup.context = context;
        imageDirectory = (imageDirectory.startsWith("/") ? "" : "/") + imageDirectory + "/";
        Set resourcePaths = context.getResourcePaths(imageDirectory);
        if (resourcePaths == null || resourcePaths.size() == 0) {
            throw new IsisException("No image directory found: " + imageDirectory);
        }
        LOG.info((Object)("image directory set to: " + imageDirectory));
        ImageLookup.imageDirectory = imageDirectory;
    }

    public static void debug(DebugString debug) {
        debug.appendTitle("Image Lookup");
        debug.indent();
        for (Object key : images.keySet()) {
            Object value = images.get(key);
            debug.appendln(key + " -> " + value);
        }
        debug.unindent();
    }

    private static String imageFile(String imageName, String contextPath) {
        for (String element : EXTENSIONS) {
            try {
                String imagePath = imageDirectory + imageName + "." + element;
                URL resource = context.getResource(imagePath);
                if (resource != null) {
                    LOG.debug((Object)("image found at " + contextPath + imagePath));
                    return contextPath + imagePath;
                }
                URL onClasspath = ImageLookup.class.getResource(imagePath);
                if (onClasspath == null) continue;
                LOG.debug((Object)("image found on classpath " + onClasspath));
                return contextPath + imagePath;
            }
            catch (MalformedURLException ignore) {
                // empty catch block
            }
        }
        return null;
    }

    private static String findImage(ObjectSpecification specification, String contextPath) {
        String path = ImageLookup.findImageFor(specification, contextPath);
        if (path == null) {
            path = ImageLookup.imageFile(UNKNOWN_IMAGE, contextPath);
        }
        return path;
    }

    private static String findImageFor(ObjectSpecification specification, String contextPath) {
        String name = specification.getShortIdentifier();
        String fileName = ImageLookup.imageFile(name, contextPath);
        if (fileName != null) {
            images.put(name, fileName);
            return fileName;
        }
        for (ObjectSpecification interfaceSpec : specification.interfaces()) {
            String path = ImageLookup.findImageFor(interfaceSpec, contextPath);
            if (path == null) continue;
            return path;
        }
        ObjectSpecification superclass = specification.superclass();
        if (superclass != null) {
            return ImageLookup.findImageFor(superclass, contextPath);
        }
        return null;
    }

    public static String imagePath(ObjectSpecification specification, String contextPath) {
        String name = specification.getShortIdentifier();
        String imageName = (String)images.get(name);
        if (imageName != null) {
            return imageName;
        }
        return ImageLookup.findImage(specification, contextPath);
    }

    public static String imagePath(ObjectAdapter object, String contextPath) {
        String name = object.getIconName();
        String imageName = (String)images.get(name);
        if (imageName != null) {
            return imageName;
        }
        String imageFile = ImageLookup.imageFile(name, contextPath);
        if (imageFile != null) {
            return imageFile;
        }
        return ImageLookup.findImage(object.getSpecification(), contextPath);
    }
}

