/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.xhtml.applib;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.WebApplicationException;

final class UrlEncodeUtils {
    private UrlEncodeUtils() {
    }

    static String encode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    static Map<String, String> urlEncode(Map<String, String> asMap) {
        HashMap<String, String> encodedMap = new HashMap<String, String>();
        Set<Map.Entry<String, String>> entrySet = asMap.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            String value = entry.getValue();
            encodedMap.put(entry.getKey(), UrlEncodeUtils.encode(value));
        }
        return encodedMap;
    }
}

