/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.commons;

import java.io.IOException;
import java.io.InputStream;
import javax.jcr.InvalidSerializedDataException;
import javax.jcr.RepositoryException;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class DefaultContentHandler
extends DefaultHandler {
    private static final Logger logger = LoggerFactory.getLogger((Class)DefaultContentHandler.class);
    private final ContentHandler handler;

    public DefaultContentHandler(ContentHandler handler) {
        this.handler = handler;
    }

    public void parse(InputStream in) throws IOException, RepositoryException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
            SAXParser parser = factory.newSAXParser();
            logger.debug("Using SAX parser " + parser.getClass().getName());
            parser.parse(new InputSource(in), (DefaultHandler)this);
        }
        catch (FactoryConfigurationError e) {
            throw new RepositoryException("SAX parser implementation not available", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new RepositoryException("SAX parser configuration error", (Throwable)e);
        }
        catch (SAXException e) {
            Exception exception = e.getException();
            if (exception instanceof RepositoryException) {
                throw (RepositoryException)((Object)exception);
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new InvalidSerializedDataException("Error parsing XML import", (Throwable)e);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.handler.characters(ch, start, length);
    }

    public void endDocument() throws SAXException {
        this.handler.endDocument();
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.handler.endElement(namespaceURI, localName, qName);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.handler.endPrefixMapping(prefix);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.handler.ignorableWhitespace(ch, start, length);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.handler.processingInstruction(target, data);
    }

    public void setDocumentLocator(Locator locator) {
        this.handler.setDocumentLocator(locator);
    }

    public void skippedEntity(String name) throws SAXException {
        this.handler.skippedEntity(name);
    }

    public void startDocument() throws SAXException {
        this.handler.startDocument();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.handler.startElement(namespaceURI, localName, qName, atts);
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.handler.startPrefixMapping(prefix, uri);
    }
}

