/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.value;

import java.util.Calendar;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.name.MalformedPathException;
import org.apache.jackrabbit.name.PathFormat;
import org.apache.jackrabbit.value.BaseValue;

public class PathValue
extends BaseValue {
    public static final int TYPE = 8;
    private final String path;

    public static PathValue valueOf(String s) throws ValueFormatException {
        if (s != null) {
            try {
                PathFormat.checkFormat(s);
            }
            catch (MalformedPathException mpe) {
                throw new ValueFormatException(mpe.getMessage());
            }
            return new PathValue(s);
        }
        throw new ValueFormatException("not a valid path format");
    }

    protected PathValue(String path) {
        super(8);
        this.path = path;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PathValue) {
            PathValue other = (PathValue)obj;
            if (this.path == other.path) {
                return true;
            }
            if (this.path != null && other.path != null) {
                return this.path.equals(other.path);
            }
        }
        return false;
    }

    public int hashCode() {
        return 0;
    }

    protected String getInternalString() throws ValueFormatException {
        if (this.path != null) {
            return this.path;
        }
        throw new ValueFormatException("empty value");
    }

    public Calendar getDate() throws ValueFormatException, IllegalStateException, RepositoryException {
        this.setValueConsumed();
        throw new ValueFormatException("conversion to date failed: inconvertible types");
    }

    public long getLong() throws ValueFormatException, IllegalStateException, RepositoryException {
        this.setValueConsumed();
        throw new ValueFormatException("conversion to long failed: inconvertible types");
    }

    public boolean getBoolean() throws ValueFormatException, IllegalStateException, RepositoryException {
        this.setValueConsumed();
        throw new ValueFormatException("conversion to boolean failed: inconvertible types");
    }

    public double getDouble() throws ValueFormatException, IllegalStateException, RepositoryException {
        this.setValueConsumed();
        throw new ValueFormatException("conversion to double failed: inconvertible types");
    }
}

